;********************************************************************
;*
;*               FILE PURPOSE AND DESCRIPTION
;*
;*		This file implements an Oversampling and averaging
;*		technique used to improve the S/N and number of
;*		useful bits in an A/D converter.
;*
;********************************************************************
;*
;* FileName:        ADOver.asm
;* Dependencies:    P16xxx or P18xxx
;* Processor:
;* Compiler:        MPLAB 5.70.02
;* Company:         Microchip Technology, Inc.
;
;* Software License Agreement
;
;* The software supplied herewith by Microchip Technology Incorporated
;* (the "Company") for its PICmicro Microcontroller is intended and
;* supplied to you, the Company's customer, for use solely and
;* exclusively on Microchip PICmicro Microcontroller products. The
;* software is owned by the Company and/or its supplier, and is
;* protected under applicable copyright laws. All rights are reserved.
;* Any use in violation of the foregoing restrictions may subject the
;* user to criminal sanctions under applicable laws, as well as to
;* civil liability for the breach of the terms and conditions of this
;* license.
;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;* Author               Date            Comment
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;* Caio Gubel      October 23, 2002    Initial Release (V1.0)
;*
;********************************************************************/

#define      ADOver_Source
#define      _ADD_PROC_INC_FILE

#define      A2D_8BIT_MODULE          ;Module definition to generate error message in
                                      ;Processors which do not have this module.
#define      _GEN_MODULE_ERROR

       include "ADOver.inc"

X=(CLOCK_FREQ/.1000000)
#if (X<0x04)
        #define ADOVERLOWFREQ         
	#define	ADOVERTADWAIT   0
#else
        #define ADOVERHIGHFREQ         
	#define	ADOVERTADWAIT   (X-5)
#endif	

_ADOVERDATA       UDATA

vADOverReadLow				RES		1					;
vADOverReadHigh				RES		1					;

vADOverValueLow				RES		1					;used to add and average values from conversions (3 bytes)
vADOverValueHigh			RES		1					;
vADOverValueUpper			RES		1					;

vADOverSampleCounterLow			RES		1					;samples counters
vADOverSampleCounterHigh		RES		1					;

vADOverSampleSizeHigh			RES		1					;number of samples
vADOverSampleSizeLow			RES		1					;

vADOverLow				RES		1					;Higher Precision A/D Calculated Values
vADOverHigh				RES		1					;
vADOverUpper				RES		1					;
vADOverSaveINTCON			RES		1					;original INTCON

_vADOverAcqTime                         RES             1

;       errorlevel      -312            ;Mask PageSel Error

	#ifdef		_PIC16xxx
		include "16ADOver.asm"
	#else
		include "18ADOver.asm"
	#endif


        END
