;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI              ;
;*  for PIC16/PIC18 family                                                      ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            SPIMInt.asm                                     ;
;* Dependencies:        P16xxx.inc                                      ;
;*                      P18xxx.inc                                      ;
;*                      SPIMInt.Inc                                     ;
;*                      SPIMInt.Def                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Apr 14, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************;***********************;
                                                ;
#define BSSP_MODULE                             ;Module definitions to generate error message for
#define _GEN_MODULE_ERROR                       ;Processor which do not have these module.
                                                ;
#define _ADD_PROC_INC_FILE                      ;
                                                ;
    #include "P16xxx.inc"                       ;
                                                ;
#define MSSP_MODULE                             ;
                                                ;
    #include "P18xxx.inc"                       ;
                                                ;
#define SPIMInt_Source                          ;
                                                ;
    #include "SPIMInt.Inc"                      ;
                                                ;
                                                ;
;***********************************************;

;***********************************************;
                                                ;
    #ifdef    _PIC18xxx                         ;
I2CMSV    UDATA_ACS                             ;
    #else                                       ;
I2CMSV    UDATA_SHR                             ;
    #endif                                      ;
                                                ;
vSPIMIntStatus          RES 1                   ;SPI Mas Communication Status/Error Register
                                                ;
SPIMSV1    UDATA                                ;
                                                ;
_vSPIMTxDataCount       RES 1                   ;Space to store number of bytes to be received
_vSPIMRxDataCount       RES 1                   ;Space to store number of bytes to be received
_vSPIMStartRxCount      RES 1                   ;SPIM Buffer Status Register
_vSPIMIntTxBufRdPtr     RES 1                   ;SPIM Buffer Read Pointer
_vSPIMIntTxBufWrPtr     RES 1                   ;SPIM Buffer Write Pointer
_vSPIMIntRxBufRdPtr     RES 1                   ;SPIM Buffer Read Pointer
_vSPIMIntRxBufWrPtr     RES 1                   ;SPIM Buffer Write Pointer
                                                ;
SPIMOV    UDATA_OVR                             ;
                                                ;
_vSPIMIntTempReg        RES 1                   ;For temporary use
_vSPIMIntDupFSR         RES 1                   ;Storage for FSR/FSR0L
    ifdef    _PIC18xxx                          ;
_vSPIMIntDupFSRH        RES 1                   ;Storage for FSR0H
    endif                                       ;
                                                ;
    #if SPIM_TX_BUF_LENGTH != 1                 ;
SPIMVT   UDATA                                  ;
    #else                                       ;
        #ifdef    _PIC18xxx                     ;
SPIMVT   UDATA_ACS                              ;
        #else                                   ;
SPIMVT   UDATA_SHR                              ;
        #endif                                  ;
    #endif                                      ;
                                                ;
vSPIMIntTxBuffer        RES SPIM_TX_BUF_LENGTH  ;SPIM Buffer
                                                ;
    #if SPIM_RX_BUF_LENGTH != 1                 ;
SPIMVR   UDATA                                  ;
    #else                                       ;
        #ifdef    _PIC18xxx                     ;
SPIMVR   UDATA_ACS                              ;
        #else                                   ;
SPIMVR   UDATA_SHR                              ;
        #endif                                  ;
    #endif                                      ;
                                                ;
vSPIMIntRxBuffer        RES SPIM_RX_BUF_LENGTH  ;SPIM Buffer
                                                ;
;***********************************************;


;***********************************************;
                                                ;
                                                ;
    #ifdef  _PIC18xxx                           ;
    include "18SPIMI.asm"                       ;
    #endif                                      ;
                                                ;
    #ifdef  _PIC16xxx                           ;
    include "16SPIMI.asm"                       ;
    #endif                                      ;
                                                ;
                                                ;
;***********************************************;

;***********************************************;
        END                                     ;
;***********************************************;

