#include <math.h>
#include "rt.h"

void PointLight::Load(const XMLNode * ln)
{
	DEBUG("Loading PointLight");
	for(NodeIterator itr = ln->Children.begin();
		itr != ln->Children.end();itr++)
	{
		if((*itr)->Name == "Position")
		{
			ParseVector((*itr)->Content,Position);
			PRINT(Position);
		}
		else if((*itr)->Name == "Color")
		{
			ParseColor((*itr)->Content,Color);
			PRINT(Color);
		}
	}
}

Color4 PointLight::IntensityAt(const Vector3D<> & pt)
{
	return Color;
}

void PointLight::VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance)
{
	outv = Position - pt;
	distance = outv.Mag();
	outv /= distance;
}


void SpotLight::Load(const XMLNode * ln)
{
	DEBUG("Loading SpotLight");
	Falloff = 1.0;				//default linear falloff
	for(NodeIterator itr = ln->Children.begin();
	 itr != ln->Children.end();itr++)
	{
		if((*itr)->Name == "Position")
		{
			ParseVector((*itr)->Content,Position);
			PRINT(Position);
		}
		else if((*itr)->Name == "Color")
		{
			ParseColor((*itr)->Content,Color);
			PRINT(Color);
		}
		else if((*itr)->Name == "Direction")
		{
			ParseVector((*itr)->Content,Direction);
			Direction.Normalize();
			PRINT(Direction);
		}
		else if((*itr)->Name == "Falloff")
		{
			Falloff = ParseDouble((*itr)->Content);
		}
	}
}

Color4 SpotLight::IntensityAt(const Vector3D<> & pt)
{
	double dot = Direction.dot((pt - Position).Norm());
	if(dot < 0) return Color4(0,0,0);
	return Color * pow(dot,Falloff);
}

void SpotLight::VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance)
{
	outv = Position - pt;
	distance = outv.Mag();
	outv /= distance;
}

void DistantLight::Load(const XMLNode * ln)
{
	DEBUG("Loading DistantLight");
	for(NodeIterator itr = ln->Children.begin();
	 itr != ln->Children.end();itr++)
	{
		if((*itr)->Name == "Position")
		{
			ParseVector((*itr)->Content,Position);
			Position.Normalize();
			PRINT(Position);
		}
		else if((*itr)->Name == "Color")
		{
			ParseColor((*itr)->Content,Color);
			PRINT(Color);
		}
	}
}

void JitteredPointLight::Load(const XMLNode * ln)
{
	DEBUG("Loading JitteredPointLight");
	for(NodeIterator itr = ln->Children.begin();
		itr != ln->Children.end();itr++)
	{
		if((*itr)->Name == "MinPos")
		{
			ParseVector((*itr)->Content,MinPos);
			PRINT(MinPos);
		}
		else if((*itr)->Name == "MaxPos")
		{
			ParseVector((*itr)->Content,MaxPos);
			PRINT(MaxPos);
		}
		else if((*itr)->Name == "Color")
		{
			ParseColor((*itr)->Content,Color);
			PRINT(Color);
		}
	}
}

void JitteredPointLight::VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance)
{
	Vector3D<> pos = Vector3D<>::RandV(MinPos,MaxPos);
	outv =  pos - pt;
	distance = outv.Mag();
	outv /= distance;
	//outv = (RAND>.5?MinPos:MaxPos) - pt;
}


