#ifndef __SCENE_H__
#define __SCENE_H__

extern int MAX_BOUNCES;
#define NUM_OBJECTS		(Objects.size())
extern int NUM_LIGHTS;

extern std::vector<Obj3D*> Objects;
extern Light ** Lights;

extern short AA;
extern Color4 Ambient;

typedef std::vector<XMLNode*>::const_iterator NodeIterator;

void LoadScene(const char * filename);

double ParseDouble(std::string s);
void ParseVector(std::string s, Vector3D<> & vec);
void ParseColor(std::string s, Color4 & col);

void ParseObjects(const XMLNode * on);
//void ParseSphere(XMLNode * sn, Sphere * s);
//void ParsePlane(XMLNode * pn, Plane * p);

void ParseLights(const XMLNode * ln);
//void ParseLight(const XMLNode * ln, Light * l);

void FreeScene();

#endif
