package antichess;

import antichess.viewgui.BoardView;

/**
 * This interface handles interactions between the Controller and the View
 * The HumanPlayer facilitates the communication between the GameController and the
 * BoardView class.  The typical communication bewtween the classes works in this manner:
 * 
 * controller calls getMove.  The HumanPlayer tells the BoardView to acceptInput.  When the BoardView
 * has input it notifies the HumanPlayer.  The HumanPlayer checks for legality in the move.  If the 
 * move is legal it notifies the controller that it has a move.
 * 
 * 
 * @author nlharr
 * 
 * @specfield board   		//Board stores the board the HumanPlayer is interacting with
 * @specfield controller 	//controller specifies the GameController that this HumanPlayer is controlled by
 * @specfield boardView 	//BoardView that the HumanPlayer asks for moves
 * @specfield currentMove	//stores the currentMove to be updated to by the GameController
 */
public interface HumanPlayer extends GamePlayer{
	
	
	/**
	 * 
	 * @return a valid move if the user has inputed one
	 */
	public Move getMove(GameController controller);
		
	
	
	/**
	 * @returns playerType
	 */
	public Player getPlayerType();
	
	/**
	 * @requires startRows, startColumns, destinationRows, destinationColumnes are all not null 
	 * @modifies currentMove
	 * @effects if the move between the start and destination is legal
	 * 			it sets currentMove to that move
	 *
	 * @return true if the move between the start and destination is legal
	 * 			else false
	 */
	public boolean setMove(int[] startRows, int[] startColumns,
										int[] destinationRows, int[] destinationColumns);
	
	/**
	 * Notifies the controller that requested a move if it has a move
	 * @throws RuntimeException if no move has been requested so there is
	 * 			no controller to return a value to
	 */
	public void notifyHasMove();
	
 
	
}
