package antichess;

import java.util.*;

public class RandomAI implements GamePlayer {

	private ChessBoard cb;
	private Player player;
	private Random r;
	
	/**
	 * Creates a new RandomAI GamePlayer object
	 * 
	 * @param cb
	 * @param player
	 */
	private RandomAI(ChessBoard cb, Player player) {
		this.cb = cb;
		this.player = player;
		this.r = new Random();
	}
	
	/* (non-Javadoc)
	 * @see antichess.GamePlayer#createPlayer(antichess.Board, antichess.Player)
	 */
	public static GamePlayer createPlayer(ChessBoard board, Player player) {
		return new RandomAI(board, player);
	}

	/* (non-Javadoc)
	 * @see antichess.GamePlayer#getMove()
	 */
	public Move getMove(GameController controller) {
		/*try{
			Thread.sleep(100);
		}catch (Exception ex){}
		*/
		
		List<ChessMove> legalMoves = cb.allLegalMoves();
		
		return legalMoves.get(r.nextInt(legalMoves.size()));
	}

	 
	
	public Player getPlayerType(){
		return this.player;
	}
	
}
