/*
 *  func.c
 */

#include <stdio.h>
#include "proto.h"
extern int errno;

void fatal (char *msg)
{
  extern int errno;
  
  fprintf (stderr, "zw: %s: %s\r\n", msg, strerror (errno));
  exit (EXIT_FAILURE);
}

void read_line (int fd, char *buf)
{
  int i = 0;

  do
  {
    if (read (fd, &buf[i], 1) == -1)
      fatal ("read_line");
  } while (buf[i ++] != 0);
}

void handle_sigcld (int sign)
{
  int val;

  while ((val = wait3 ((union wait *) NULL, WNOHANG, (struct rusage *)NULL)) != 0)
    if (val == -1)
      if (errno == EINTR)
	continue;
      else if (errno == ECHILD)
	break;
      else
	fatal ("wait3");
  return;
}











