/*****************************************************************************

			       XCopilot

This code is part of XCopilot, a port of copilot

     Portions of this code are Copyright (C) 1997 Ivan A. Curtis
		       icurtis@radlogic.com.au

The original MS-Windows95 copilot emulator was written by Greg Hewgill.
The following copyright notice appeared on the original copilot sources:

		  Copyright (c) 1996 Greg Hewgill

 MC68000 Emulation code is from Bernd Schmidt's Unix Amiga Emulator.
       The following copyright notice appeared in those files:

	  Original UAE code Copyright (c) 1995 Bernd Schmidt

This code must not be distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	newcpu.h

Description:	MC68000 emulation

Update History:   (most recent first)
   I. Curtis   5-Mar-97 20:35 -- moved regflags into regs field of shared img
   I. Curtis  26-Feb-97 15:00 -- modified from win95 version

******************************************************************************/

extern shared_img *Shptr;

extern int ExceptionFlags[48];

extern int areg_byteinc[];
extern int imm8_table[];

typedef void cpuop_func(ULONG);

struct cputbl {
    cpuop_func *handler;
    int specific;
    UWORD opcode;
};

extern shared_img *Shptr;
extern struct cputbl smallcputbl[];

extern cpuop_func *cpufunctbl[65536];
extern void op_illg(ULONG);

#define ZFLG ((Shptr->regs).z)
#define NFLG ((Shptr->regs).n)
#define CFLG ((Shptr->regs).c)
#define VFLG ((Shptr->regs).v)

extern UWORD nextiword(void);
extern ULONG nextilong(void);
extern int cctrue(const int cc);
extern ULONG get_disp_ea (ULONG base, UWORD dp);
extern void MakeSR(void);
extern void MakeFromSR(void);
extern void MC68000_setshare(shared_img *shptr);
extern void MC68000_oldstep(UWORD opcode);
extern void MC68000_setpc(CPTR newpc);
extern CPTR MC68000_getpc(void);
extern void MC68000_setstopped(int stop);
extern void MC68000_exception(int);
extern void MC68000_init(shared_img *shptr);
extern void MC68000_reset(void);
extern void MC68000_run(void);
extern void MC68000_step(void);
extern void MC68000_skip(CPTR);
