/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/basic.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/
#ifndef __MX_BASIC
#define __MX_BASIC

#ifndef NULL
#define NULL 0
#endif

#include "X11/Xlib.h"
#include "X11/Xutil.h"

#define MXItemFlag_Left       0
#define MXItemFlag_Center     1
#define MXItemFlag_Right      2
#define MXItemMask_Align      3
#define MXItemFlag_Disabled   4
#define MXItemFlag_Hilite     8
#define MXItemFlag_Underlined 16
#define MXItemFlag_Overlined  32
#define MXItemFlag_Boxed      48

#define mx_min(a, b) ((a) < (b) ? (a) : (b))
#define mx_max(a, b) ((a) > (b) ? (a) : (b))

/***************************************
 * A menu item has text and attributes *
 ***************************************/
typedef struct _mx_menu_item {
  int flag;			/* alignment, disabled etc. */
  char *text;			/* the text string */
  int length;			/* length of the text string */
} mx_menu_item;

/****************************************
 * An appearance structure contains the *
 * parameters which define the overall  *
 * appearance of menus etc.             *
 ****************************************/
typedef struct _mx_appearance {
  int win_border;		/* size of window border (pixels) */
  int item_border;		/* amount of room around each item (pixels) */
  XFontStruct *font;		/* a font structure */
  int em, ascent, descent;	/* font characteristics (pixels) */
  GC gcf, gcd;			/* flipping and drawing GCs */
  Pixmap stipple;		/* a bitmap for stipple patterns */
  Pixmap button;		/* a bitmap for buttons */
  int button_width,
    button_height;
  int (*expose_fun)();		/* function to call for exposure */
} mx_appearance;

typedef struct _mx_panel {
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of each panel item (pixels) */
  int n_items;			/* number of items in panel */
  mx_menu_item *item;		/* pointer to an array of items */
  int first_item, last_item;	/* sub-range of items used */
} mx_panel;


extern Window mx_window_open(Display *display, int screen, char *title,
			     int WindowXSize, int WindowYSize,
			     int WindowBorder);

extern mx_panel *mx_panel_create(Display *display, mx_appearance *app,
				 int n_items, mx_menu_item *mi);

extern mx_appearance *mx_appearance_create(Display *display, int screen,
					   Window window,
					   char *font_name,
					   int win_border, int item_border,
					   int pix_width, int pix_height,
					   char *pix_bits,
					   int (*expose_fun)(void));

extern void mx_items_draw(Display *display, Window window, mx_appearance *app,
			  mx_menu_item *item, int start_item, int max_items,
			  int width, int height,
			  int tlx, int tly);

extern void mx_adjust_xy(Display *display, int width, int height,
			 int *x, int *y);

extern Window mx_transient_window_open(Display *display, int screen,
				       int border, int xpos, int ypos,
				       int xsize, int ysize);

extern void mx_window_close(Display *display, Window window);

#endif
