/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/filesel.c

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef SUNOS414
#  include <sys/types.h>
#  include <sys/dir.h>
#  define dirent direct
#else
#  include <dirent.h>
#endif
#include <sys/stat.h>
#include <unistd.h>
#include "basic.h"
#include "menu.h"
#include "select.h"

#ifdef SUNOS414
extern int scandir(char *dirname, struct direct **namelist, int (*select)(),
		    int (*compar)());
extern int alphasort(struct direct **d1, struct direct **d2);
#endif

/*
 * This function used to filter entries for
 * the file selector. We want all files, so
 * we always return 1
 */
int mx_dir_sel(const struct dirent *ent)
{
  return 1;
}

/*
 * This function is used by qsort to sort
 * entries in the file selection. We make
 * a directory always less than an ordinary
 * file, that way all the directories are
 * listed at the head of the list
 */
int mx_dir_sort(const struct dirent * const *a, const struct dirent * const *b)
{
  struct stat sa, sb;
  struct dirent *da, *db;
  da = (struct dirent *)*a;
  db = (struct dirent *)*b;
  if (stat(da->d_name, &sa) == -1) {
    /*    perror(da->d_name);*/
    return 1;
  }
  if (stat(db->d_name, &sb) == -1) {
    /* perror(db->d_name); */
    return -1;
  }
  if (S_ISDIR(sa.st_mode) == S_ISDIR(sb.st_mode)) {
    return alphasort(a, b);
  } else if (S_ISDIR(sa.st_mode)) {
    return -1;
  } else {
    return 1;
  }
}

mx_menu_item *mx_dir_items(const char *dir, int *sel_nitems)
{
  int i, nitems;
  struct dirent **namelist;
  mx_menu_item *items;

  nitems = scandir(dir, &namelist, mx_dir_sel, mx_dir_sort);
  if (nitems > 0) {
    struct stat sa;
    items = (mx_menu_item *)malloc((nitems + 1) * sizeof(mx_menu_item));
    items[0].flag = MXItemFlag_Center;
    items[0].text = "Select File";
    items[0].length = 0;
    for (i = 0; i < nitems; i++) {
      if (stat(namelist[i]->d_name, &sa) == 0) {
	items[i + 1].flag = MXItemFlag_Left;
	if (S_ISDIR(sa.st_mode)) {
	  items[i + 1].text = (char *)malloc(strlen(namelist[i]->d_name) + 2);
	  strcpy(items[i + 1].text, namelist[i]->d_name);
	  strcat(items[i + 1].text, "/");
	} else {
	  items[i + 1].text = namelist[i]->d_name;
	} 
      } else {
	items[i + 1].flag = MXItemFlag_Left | MXItemFlag_Disabled;
	items[i + 1].text = namelist[i]->d_name;
      }
      items[i + 1].length = 0;
    }
    *sel_nitems = nitems + 1;
    return items;
  } else {
    *sel_nitems = 0;
    return NULL;
  }
}

char *mx_popup_filesel(Display *display, int screen,
		       mx_appearance *app,
		       int *x, int *y)
{
  int choice, looping;
  int sel_nitems;
  int rx, ry;
  mx_menu_item *sel_items;
  mx_panel *panel_select = NULL;

  choice = -1;
  looping = 1;
  while (looping) {
    int idx;
    rx = *x;
    ry = *y;
    if (panel_select != NULL) {
      free(panel_select);
    }

    sel_items = mx_dir_items(".", &sel_nitems);
    if (sel_nitems <= 0) {
      break;
    }

    panel_select = mx_panel_create(display, app, sel_nitems, sel_items);
    choice = mx_popup_select(display, screen, panel_select,
			     &rx, &ry, mx_min(sel_nitems - 1, 8));
    if (choice < 0) {
      break;
    }

    idx = strlen(panel_select->item[choice].text) - 1;
    if (panel_select->item[choice].text[idx] == '/') {
      chdir(panel_select->item[choice].text);
    } else {
      looping = 0;
    }
  }

  *x = rx;
  *y = ry;
  if (!looping) {
    return panel_select->item[choice].text;
  } else {
    return NULL;
  }
}
