/*****************************************************************************

			       XCopilot

This code is part of XCopilot, a port of copilot

     Portions of this code are Copyright (C) 1997 Ivan A. Curtis
		       icurtis@radlogic.com.au

The original MS-Windows95 copilot emulator was written by Greg Hewgill.
The following copyright notice appeared on the original copilot sources:

		  Copyright (c) 1996 Greg Hewgill

 MC68000 Emulation code is from Bernd Schmidt's Unix Amiga Emulator.
       The following copyright notice appeared in those files:

	  Original UAE code Copyright (c) 1995 Bernd Schmidt

This code must not be distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	pilotcpu.h

Description:	pilotcpu interface

Update History:   (most recent first)

******************************************************************************/
/************************
struct CPU_regs {
  unsigned long d[8];
  unsigned long a[8], usp;
  unsigned short sr;
  unsigned char t;
  unsigned char s;
  unsigned char x;
  unsigned char stopped;
  int intmask;
  unsigned long pc;
  union flagu flags;
  unsigned long dummy;
};
***************************/

extern int CPU(shared_img *shptr);
extern int CPU_init(shared_img *shptr, int ramsize);
extern void CPU_wait(shared_img *shptr);
extern void CPU_reset(shared_img *shptr);
extern void CPU_start(shared_img *shptr);
extern void CPU_stop(shared_img *shptr);
extern char *CPU_getstate(shared_img *shptr);
extern void *CPU_getmemptr(CPTR addr);
extern void CPU_getregs(shared_img *shptr, struct regstruct *r);
extern void CPU_setregs(shared_img *shptr, struct regstruct *r);
extern ULONG CPU_getlong(CPTR addr);
extern UWORD CPU_getword(CPTR addr);
extern UBYTE CPU_getbyte(CPTR addr);
extern void CPU_putbyte(CPTR addr, UBYTE x);
extern void CPU_putword(CPTR addr, UWORD x);
extern void CPU_putlong(CPTR addr, ULONG x);
int CPU_setexceptionflag(shared_img *shptr, int exception, int flag);
void CPU_loadapp(shared_img *shptr);
