#
#  $Id: DTKInput.py,v 1.1 1999/05/27 09:30:49 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""
"""

__version__ = '$Id: DTKInput.py,v 1.1 1999/05/27 09:30:49 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

from Pyrite.Plugin import Plugin

import urllib, os

class DTKInput(Plugin):
    type = 'DTKInput'
    type_name = 'DTK Input Format'

    def __init__(self, *a, **kw):
	apply(Plugin.__init__, (self,)+a, kw)
	self.config_path = 'DocToolkit::Input'
	if self.name:
	    self.config_path = self.config_path + '::' + self.name
	
    def open(self, fn):
	"""Open a file.
	This is included here because some input formats may support
	'filenames' which don't refer to files per se, and those will
	need a hook through which to open them.  For example, a
	hypothetical 'Headlines' input format might take news source
	names on the command line, e.g.
	    dtk -I Headlines PalmStation PGHQ Slashdot LinuxToday

        The standard behavior handles URLs and gzipped files.

	Return value is:
	  (token, basename)
	where 'token' is somethign arbitrary that can be passed to the
	input method callback, and 'basename' is a basename which can
	be used for the output file.
	"""
	f = urllib.urlopen(fn)  # raises IOError if fails

	n, e = os.path.splitext(os.path.basename(fn))
	if e == '.gz':
	    f = GzipFile(filename="", mode="rb", fileobj=f)
	    n, e = os.path.splitext(n)
	
	return f, os.path.basename(fn)


    def convert(self, f, w):
	pass
    
