#
#  $Id: TealDoc.py,v 1.1 1999/05/27 09:30:49 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""
"""

__version__ = '$Id: TealDoc.py,v 1.1 1999/05/27 09:30:49 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import string

from Pyrite.App import Doc

# ack!  I need __!
from DocToolkit import metrics

import DTKOutput
from Basic import BasicDTKOutput, BasicDocWriter

teal_header_attrs = {
    1: {'FONT': '2', 'ALIGN': 'CENTER', 'STYLE': 'NORMAL'},
    2: {'FONT': '1', 'ALIGN': 'LEFT', 'STYLE': 'UNDERLINE'},
    3: {'FONT': '1', 'ALIGN': 'LEFT', 'STYLE': 'NORMAL'},
    4: {'FONT': '0', 'ALIGN': 'LEFT', 'STYLE': 'UNDERLINE'},
    5: {'FONT': '0', 'ALIGN': 'LEFT', 'STYLE': 'UNDERLINE'},
    6: {'FONT': '0', 'ALIGN': 'LEFT', 'STYLE': 'UNDERLINE'}
    }
teal_header_fonts = {
    1: 2,
    2: 1,
    3: 1
    }
teal_default_header_attrs = {'FONT': '0', 'ALIGN': 'LEFT', 'STYLE': 'NORMAL'}

class TealDocDTKOutput(BasicDTKOutput):
    name = 'TealDoc'
    version = '$Revision: 1.1 $'
    author = 'Rob Tillotson <robt@debian.org>'
    url = ''
    description = 'TealDoc-enhanced Doc format.'

    def open(self, store, base='', title='', creator='REAd', type='TEXt',
	     backup=1, category=0, version=1):

	if creator == 'REAd': creator = 'TlDc' ###
	return BasicDTKOutput.open(self, store, base, title, creator,
				   type, backup, category, version,
				   writerclass=TealDocWriter)
    
class TealDocWriter(BasicDocWriter):
    def __init__(self, *a, **kw):
	apply(BasicDocWriter.__init__, (self,)+a, kw)
	self.teal_bookmarks = 0
	
    def send_raw_tag(self, tagname, attr={}):
	self.flush()
	self.doc.write('<'+tagname)
	if attr:
	    self.doc.write(' ')
	    self.doc.write(string.join(map(lambda x: '%s=%s' % x, attr.items())))
	self.doc.write('>')
	
    def set_bookmark(self, s):
	if self.teal_bookmarks:
	    self.send_raw_tag('BOOKMARK',{'NAME':'"%s"' % s[:15]})
	else:
	    BasicDocWriter.set_bookmark(self, s)

    def send_heading(self, text, level=1):
	l = metrics.wordwrap(text, max_width=160,
			     font=teal_header_fonts.get(level, 0))
	for t in l:
	    d = {'TEXT': '"%s"' % t}
	    d.update(teal_header_attrs.get(level, teal_default_header_attrs))
	    self.send_raw_tag('HEADER', d)
	    if not d.get('FONT') == '2':
		self.send_line_break()
	if d.get('FONT') == '2':
	    self.send_line_break()

    def send_hor_rule(self, *a, **kw):
	# later, do things based on 'break' and 'char'
	self.send_raw_tag('HRULE')
	self.doc.write('\n')
	
	
