#!/usr/bin/python
#
#  $Id: install.py,v 1.12 1999/11/29 06:57:18 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Install.
"""

__version__ = '$Id: install.py,v 1.12 1999/11/29 06:57:18 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


import Pyrite
from Pyrite import _
from Pyrite.Application import Application
from Sulfur import Options
from Sulfur.Options import O_NOCONFIG, O_NONINTERACTIVE

import sys, os, string, pprint

class App(Application):
    name = 'Pyrite Database File Installer'
    version = Pyrite.version
    author = 'Rob Tillotson <robt@debian.org>'
    description = _("Install databases stored in prc/pdb files.")
    extra_help = _("Give filenames to install as extra arguments.")

    options = [
	Options.String('user', None, _("user name to install as"), None, None,
		       ['user','U']),
	Options.Boolean('immediate', None, _("install immediately without spooling"),
			None, None, ['immediate', 'i']),
	Options.Boolean('list', None, _("list databases already spooled"), None,
			(O_NOCONFIG, O_NONINTERACTIVE), ['list', 'l']),
	]
	
    def __init__(self):
	Application.__init__(self)

	self.config_path = 'Pyrite::Install'

    def run(self, argv):
	if self.get_option('help'): return

	if self.get_option('user'):
	    self.user = self.get_option('user')
	    self.configure_user()

	if self.get_option('list'):
	    store = self.user_directory('install')
	    print _("Databases awaiting installation for %s:") % self.user
	    print
	    for i in store.listinfo():
		print "%-32s %s [%4s/%4s]" % (i['name'],
					     i['flagResource'] and 'PRC' or 'PDB',
					     i['creator'], i['type'])
	    print
	    return
	
	if not argv:
	    print _("No files specified, nothing installed.")
	    print
	    self.process_help()
	    return
	    
	if self.get_option('immediate'):
	    store = self.connect(1)
	else:
	    store = self.user_directory('install')

	fs = self.get_plugin('Store', 'File')
	for fn in argv:
	    s = fs(fn)
	    l = s.list()
	    if not l:
		print _("Error reading '%s'.") % fn
		continue

	    print _("Installing '%s' (%s)...") % (l[0], fn),
	    store.install(s, l[0])
	    print _(" done.")

	    
    


if __name__ == '__main__':
    a = App()
    a()
