/**********************************************************************
 *  start.c -- start Athena login session
 *
 * Copyright 1994 by the Massachusetts Institute of Technology
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 **********************************************************************/
#include <mit-copyright.h>

#include <AL/AL.h>

/* Start Athena login session */

long
ALstart(ALsession session, char *hostname)
{
  long code;
  ALut ut;

  /* add user to passwd file */
  if ((code=ALaddPasswdEntry(session)) != 0L) return(code);

  /* add groups to groups file */
  if ((code=ALaddToGroupsFile(session)) != 0L) return(code);

  /* attach/make home directory */
  if ((code=ALgetHomedir(session)) != 0L) return(code);

  /* create utmp entry (if hostname != NULL) */
  if (hostname) {
      ut.host = hostname;
      ALsetUtmpInfo(session, ALutHOST, &ut);
      if ((code=ALputUtmp(session)) != 0L) return(code);
  }

  return 0L;
}

long ALend(ALsession session)
{
  /* remove user from passwd file. */
  ALremovePasswdEntry(session);

  /* remove groups from groups file */
  ALremoveFromGroupsFile(session);

  /* detach home directory */
  /* remove temporary directory */
  /* remove utmp entry */

  return 0L;
}
