/* This file contains definitions for use by the Hesiod name service and
 * applications.
 *
 * For copying and distribution information, see the file <mit-copyright.h>.
 *
 * Original version by Steve Dyer, IBM/Project Athena.
 *
 *	$Id: hesiod.h.sed,v 1.2 1996/06/01 18:46:32 ghudson Exp $
 */

#ifndef __HESIOD_H
#define __HESIOD_H

/* Configuration information. */

#define HESIOD_CONF	"CONFDIR/hesiod.conf"	/* Configuration file. */
#define DEF_RHS		".Athena.MIT.EDU"	/* Defaults if HESIOD_CONF */
#define DEF_LHS		".ns"			/*    file is not present. */

/* Error codes. */

#define	HES_ER_UNINIT	-1	/* uninitialized */
#define	HES_ER_OK	0	/* no error */
#define	HES_ER_NOTFOUND	1	/* Hesiod name not found by server */
#define HES_ER_CONFIG	2	/* local problem (no config file?) */
#define HES_ER_NET	3	/* network problem */
#define HES_ER_RANGE	4	/* return buffer not large enough */
#define HES_ER_NOMEM	5	/* insufficient memory is available */
#define HES_ER_INVAL	6	/* invalid response from hesiod server */

/* For use in getting post-office information. */

struct hes_postoffice {
	char	*po_type;
	char	*po_host;
	char	*po_name;
};

/* Declaration of routines */

#ifdef __STDC__

struct passwd;
struct servent;

/* Thread-safe. */
int hes_init(void);
int hes_to_bind_r(char *name, char *type, char *buffer, int buflen);
int hes_resolve_r(char *name, char *type, char **retvec, int retveclen);
int hes_getpwnam_r(char *nam, struct passwd *entry, char *buf, int bufsize);
int hes_getpwuid_r(int uid, struct passwd *entry, char *buf, int bufsize);
int hes_getmailhost_r(char *user, struct hes_postoffice *ret,
		      char *linebuf, int bufsize);
int hes_getservbyname_r(char *name, char *proto, struct servent *result,
			char *buffer, int buflen);

/* Non-thread-safe. */
char *hes_to_bind(char *name, char *type);
char **hes_resolve(char *name, char *type);
int hes_error(void);
struct passwd *hes_getpwnam(char *nam);
struct passwd *hes_getpwuid(int uid);
struct hes_postoffice *hes_getmailhost(char *user);
struct servent *hes_getservbyname(char *name, char *proto);

#else

char *hes_to_bind(), **hes_resolve();
int hes_init(), hes_error(), hes_to_bind_r(), hes_resolve_r();
int hes_getmailhost_r(), hes_getservbyname_r();
int hes_getpwnam_r(), hes_getpwuid_r();
struct hes_postoffice *hes_getmailhost();
struct servent *hes_getservbyname();
struct passwd *hes_getpwnam(), *hes_getpwuid();

#endif /* __STDC__ */

#endif /* __HESIOD_H */

