# Copyright (c) 1995 by the Student Information Processing Board
# 	  of the Massachusetts Institute of Technology
#  
# Permission to use, copy, modify, and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation,
# and that the names of M.I.T. and the M.I.T. S.I.P.B. not be
# used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# M.I.T. and the M.I.T. S.I.P.B. make no representations about
# the suitability of this software for any purpose.  It is
# provided "as is" without express or implied warranty.
#
#	$Id: disksetup.sh,v 1.1 1995/12/16 22:20:48 ghudson Exp $
#	$Source: /mit/netbsd/dev/install/server/RCS/disksetup.sh,v $

# Files created:
#	/tmp/geometries		Disk geometries (disk, cyls, heads, sectors)
#	/tmp/netbsdpart		NetBSD partitions (disk, start, size)
#	/tmp/freespace		Free areas (disk, start, size)

min=20480			# Minimum size of an interesting empty space
disks="wd0 wd1 sd0 sd1 sd2"	# Supported disk devices

# Find disk geometries
for i in $disks; do
	fdisk /dev/r${i}d 2>&1 | awk -F "=| " -v disk=$i '
		/^cylinders=/	{ cyl = $2; heads = $4; sect = $6; }
		END		{ if (cyl) print disk, cyl, heads, sect }'
done > /tmp/geometries

# Find all disks with a NetBSD partition.
for i in $disks; do
	fdisk /dev/r${i}d 2>&1 | awk -F ",?[ \t]*" -v disk=$i '
		/^sysid 165/	{ getline;
				  if ($3 > 0) { start = $3; size = $5; } }
		END		{ if (start) print disk, start, size; }'
done > /tmp/netbsdpart

# Scan fdisk output and compute empty sections of disks.
for i in $disks; do
	fdisk /dev/r${i}d 2>&1 | awk -F ",?[ \t]*" -v disk=$i -v min=$min '
		BEGIN		{ n = 0; }
		/^cylinders=/	{ cyl = $2; heads = $4; sect = $6; }
		/, size [^0]/	{ start[n] = $3; size[n] = $5; n++; }
		END {
			if (n >= 4)
				exit 0;

			# Sort gathered information by starting sector.
			for (i = 1; i < n; i++) {
				tstart = start[i];
				tsize = size[i];
				for (j = i - 1; j >= 0; j--) {
					if (tstart > start[j])
						break;
					start[j + 1] = start[j];
					size[j + 1] = size[j];
				}
				start[j + 1] = tstart;
				size[j + 1] = tsize;
			}

			# Output list of free sections.
			csect=sect - 1;
			for (i in start) {
				if (start[i] - csect >= min)
					print disk, csect, start[i] - csect;
				if (csect < start[i] + size[i])
					csect = start[i] + size[i];
			}
			total = cyl * heads * sect;
			if (total - csect >= min)
				print disk, csect, total - csect;
		}'
done > /tmp/freespace

if [ ! -s /tmp/netbsdpart -a ! -s /tmp/freespace ]; then
	echo "Didn't find any NetBSD partitions or blocks of free"
	echo "sectors.  You must free up space on your hard disk"
	echo "before installing."
	exit 1
fi

