# Copyright (c) 1995 by the Student Information Processing Board
# 	  of the Massachusetts Institute of Technology
#  
# Permission to use, copy, modify, and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation,
# and that the names of M.I.T. and the M.I.T. S.I.P.B. not be
# used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# M.I.T. and the M.I.T. S.I.P.B. make no representations about
# the suitability of this software for any purpose.  It is
# provided "as is" without express or implied warranty.
#
#	$Id: install.sh,v 1.33 1996/06/01 18:37:58 ghudson Exp $
#	$Source: /afs/sipb/project/sipb-athena/src/install/arch/i386_nbsd1/RCS/install.sh,v $

# /tmp/vars outputs:
#	revision	install.sh revision number
#	distsite	distribution site for FTPing tarfiles
#	installdir	installation directory for FTPing tarfiles

. /tmp/vars

fail() {
	echo ""
	echo "The installation procedure has failed.  Please contact"
	echo "netbsd-help@mit.edu for help, or call the SIPB office at"
	echo "253-7788.  Please type 'halt' now."
	exit 1
}

umount /hd/u1/usr/vice/cache /hd/u1 /hd >/dev/null 2>&1

echo ""
echo "If you have problems during this installation, you can restart it by"
echo "pressing ^C and typing '/srvd/install/install'."

revision='$Revision: 1.33 $'
cat >> /tmp/vars << EOM
revision='$revision'
distsite=sipb.mit.edu
installdir=installkits/i386_nbsd1/athena-${athenarev}
EOM

/srvd/install/hdinfo || fail
/srvd/install/questions || fail
/srvd/install/subscribe || fail
/srvd/install/disksetup || fail
/srvd/install/unpack || fail
/srvd/install/config || fail
/srvd/install/mail || fail

case "$action" in
	reboot)
		echo "Installation complete.  Rebooting... "
		reboot
		;;
	halt)
		echo "Installation complete.  Halting... "
		halt
		;;
	exit)
		echo 'Installation complete.  Be certain to use the "halt"'
		echo "command when rebooting your machine; otherwise your"
		echo "filesystem WILL be left in an inconsistent state, and"
		echo "your machine will not function properly."
		;;
esac

