/*
 *	$Source: /local/cvsfiles/kerberos/src/appl/tftp/tcom.c,v $
 *	$Author: eichin $
 *	$Locker:  $
 *	$Log: tcom.c,v $
 * Revision 1.2  1993/01/05  23:03:11  eichin
 * change <strings.h> to <string.h>
 * delete extraneous declaration of index
 * change index to strchr
 *
 * Revision 1.1.1.2  1991/12/03  18:47:37  eichin
 * Athena Kerberos 4 patch 9
 *
 * Revision 4.3  89/01/24  21:47:33  jtkohl
 * Programmer: Bill Sommerfeld
 * Auditor: John Kohl
 * changes: use fgets() instead of gets()
 * 
 * Revision 4.2  88/03/16  18:37:28  steiner
 * Removed improper #.
 * Programmer: wesommer.
 * Auditor: jtkohl.
 * 
 * Revision 4.1  87/09/01  16:33:26  steiner
 * No change; starting version 4.
 * 
 * Revision 2.1  85/12/12  10:53:41  bcn
 * Change majore version number to 2.
 * 
 * Revision 1.1  85/06/07  21:45:31  martillo
 * Initial revision
 * 
 */

#ifndef lint
static char *rcsid_tcom_c = "$Header: /local/cvsfiles/kerberos/src/appl/tftp/tcom.c,v 1.2 1993/01/05 23:03:11 eichin Exp $";
#endif	lint

/* tcom.c */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	"notice.h"


/* EMACS_MODES: c !fill */

/* Send a command to the tftp server */

#include	<stdio.h>
#include	<string.h>
#include	<signal.h>
#include	"srvr_cmds.h"

#define	LINSIZ	128
char	*lockfile = "/tftpd/lock";
char	*tftplog = "/tftpd/slog";
char	*showlog = "/exe/showlog";

main (argc, argv)
int	argc;
char	**argv;
{
	FILE	*cmdfd, *lockfd;
	char	line[LINSIZ];
	int	i, pid, child;

	if ((lockfd = fopen (lockfile, "r")) == NULL) {
		printf ("tftp daemon not alive");
		exit (1);
	}

	fscanf (lockfd, "%d", &pid);
	fclose (lockfd);
	
	if (argc > 1) {		/* run once? */
		
		if ((cmdfd = fopen (CMD_FILE, "w")) == NULL) {
			printf ("can't open command file\n");
			exit (1);
		}
		
		for (i = 1; i < argc; i++) {
			fputs (argv[i], cmdfd);
			putc (' ', cmdfd);
		}
	
		fclose (cmdfd);
	
		kill (pid, CMD_SIG);
	} else {			/* run interactively */
		if ((child = fork ()) == 0)	/* child */
			execl (showlog, showlog, tftplog, 0);
		printf ("(Type EOF to exit)\n");
		while (fgets (line, LINSIZ, stdin) != NULL) {
			char *ptr;
			
			if ((ptr = strchr(line, '\n')) != 0)
				*ptr = '\0';
			if ((cmdfd = fopen (CMD_FILE, "w")) == NULL) {
				printf ("can't open command file\n");
				exit (1);
			}
			fputs (line, cmdfd);
			fclose (cmdfd);
			kill (pid, CMD_SIG);
		}
		kill (child, SIGINT);	/* punt child */
	}
			
}
