#if !defined(lint) && !defined(SABER)
static char rcsid[] = "$Id: environment.c,v 1.4 93/10/07 13:59:01 vrt Exp $";
#endif

#include "mkserv.h"

/* Handle environment variables */

/* 
 * insert_env(char *name, char *value)
 * Common interface - will use putenv if needed
 * Returns: 0 - success
 *	    -1 - failure
 */

insert_env(char *name, char *value) 
{
#if defined(_IBMR2) || defined(sun)
	char buf[200], *p;
	sprintf(buf, "%s=%s", name, value);
	p = strdup(buf);
	if(p) 
		return(putenv(p));
	else 
		return -1;
#else
	return(setenv(name, value, 1));
#endif
}

/* 
 * setup_env()
 *   sets the environment up based on the requirements of mkserv 
 *   Returns:
 *	0 - success
 *	-1 - failure - do to lack of memory
 */
setup_env(struct local_env *env)
{
	char *p, *p1;
	char path[MAXPATHLEN+1];
	char buf[BUFSIZ];

	bzero(env, sizeof(struct local_env));
	
	strcpy(path, "/bin/athena:/usr/athena/bin:/usr/athena/etc:/usr/ucb:/bin:/usr/bin:/etc:/usr/etc:");

	/* Handle RVDROOT - may be passed in */
	if((p = getenv("RVDROOT")) == NULL) {
		if(insert_env("RVDROOT", DEF_RVDROOT)) return -1;
		p = DEF_RVDROOT;
	}

	env->rvdroot = strdup(p);

	/* ${RVDROOT}/usr/bin */
	strcat(path, p);
	strcat(path, "/usr/bin:");

	/* Handle SRVDIR - may be passed by the environment */
	if((p = getenv("SRVDIR")) == NULL) {
		if(insert_env("SRVDIR", DEF_SRVDIR)) return -1;
		p = DEF_SRVDIR;
	}

	/* ${SRVDIR} */
	strcat(path, p);

	env->srvdir = strdup(p);
	
	if(insert_env("PATH", path)) return -1;

	if(insert_env("LOGFILE", DEF_LOGFILE)) return -1;

	env->logfile = strdup(DEF_LOGFILE);

	/* SYNCOPTS needed? */

	/* Get VERS and MACH */
	if(tail_file(os_versionfile(), buf)) {
		fprintf(stderr, "%s missing\n", os_versionfile());
		if(insert_env("VERS", "???")) return -1;
		if(insert_env("MACH", "???")) return -1;
	} else {
		p = buf;
		/* Skip over "Athena Workstation" */
		while(*p && *p != '(') p++;
		if(! *p || ! *++p) {
			fprintf(stderr, "Version file format wrong\n");
			if(insert_env("VERS", "???")) return -1;
			if(insert_env("MACH", "???")) return -1;
			goto vers_out;
		}
		p1 = p;
		while(*p1 && *p1 != ')') p1++;
		if(*p1) {
			*p1 = '\0';
			if(insert_env("MACH", p)) return -1;
			p = p1 + 1;
			
			/* Find VERS */
			while(*p && isspace(*p)) p++;
			if(*p && !strncmp(p, "Version ", strlen("Version "))) {
				p += strlen("Version ");
				p1 = p;
				while(*p1 && !isspace(*p1)) p1++;
				*p1 = '\0';
				if(insert_env("VERS", p)) return -1;
			} else {
				fprintf(stderr, "No version in Version file\n");
				
				if(insert_env("VERS", "???")) return -1;
			}
		}
		else {
			fprintf(stderr, "Version file format wrong\n");
			if(insert_env("VERS", "???")) return -1;
			if(insert_env("MACH", "???")) return -1;
			goto vers_out;
		}
	} /* tail_file */
vers_out:		
	env->vers = strdup(getenv("VERS"));
	env->mach = strdup(getenv("MACH"));

	if(insert_env("SERVERDIR", os_serverdir())) return -1;

	if(insert_env("SITE", os_sitedir())) return -1;

	env->serverdir = strdup(getenv("SERVERDIR"));
	sprintf(buf, "%s/config", env->serverdir);

	if(insert_env("CONFIGDIR", buf)) return -1;

	env->configdir = strdup(getenv("CONFIGDIR"));

 	if(insert_env("SERVICES", "/tmp/services.mkserv")) return -1;
	env->services = strdup(getenv("SERVICES"));

 	if(insert_env("CONFCNG", "/tmp/mkserv.confcng")) return -1;
	env->confcng = strdup(getenv("CONFCNG"));

	return 0;

}
