/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /source/athena/athena.bin/olh/ascii/RCS/main.c,v $
 *	$Id: main.c,v 1.13 1992/04/05 17:09:42 probe Exp $
 *	$Author: probe $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /source/athena/athena.bin/olh/ascii/RCS/main.c,v 1.13 1992/04/05 17:09:42 probe Exp $";
#endif
#endif

#include "olh.h"

/*
 *  Global data- blech.
 */

Menu *menu[512];
MenuEntry *menu_entry[512];

short current[512];
short viewed[512];
short current_menu = 0;

MenuEntry *top_entry;
char *top_pointer;

char *program;
int hist_on;
int doing_keywords = 0;
int keyword_level = 0;

/*
 *  Static data
 */


int scount;
WINDOW* scr[SCR_MAX];

WINDOW* scr_prim;
WINDOW* scr_view;
WINDOW* scr_sugg;

int current_screen;


/*  Windows  */

int wcount;
WINDOW* win[WIN_MAX];

WINDOW* win_heading;
WINDOW* win_instr;
WINDOW* win_label;
WINDOW* win_entries;
WINDOW* win_above;
WINDOW* win_below;
WINDOW* win_prompt;
WINDOW* win_message;
WINDOW* win_view_wait;
WINDOW* win_sugg_wait;


/*  Menu information  */

int current_offset = 0;
int selection = 0;
int menu_lines;
int prev_above;
int prev_below;


/*  Prompt information  */

char* current_prompt = NULL;
char current_input[SMALL_BUFFER];


/*  Message information  */

char current_message[80];

/*  Screen size information  */

int max_lines = 0;
int max_cols = 0;

int current_instr = INSTR_NORMAL_TOP;

void
  main(argc, argv)
int argc;
char **argv;
{
  long code;	/* Error code returned from libmenu routines */
  Menu *m;	/* Pointer to main menu */
  MenuEntry *e;	/* */
  
  /*
   *  Find out what my name is today...  useful for printing in error
   *  messages, etc.
   */
  
  program = rindex(*argv,'/');
  if(program == (char *) NULL)
    program = *argv;
  if(*program == '/')
    ++program;
  
  /*
   * Set up signal handlers
   */

  signal(SIGINT, handle_interrupt_event);
  signal(SIGWINCH, handle_resize_event);

  /*
   *  First, try creating display.  If this fails, print a 'nice' error
   *  message and exit.
   */
  
  if (! curses_init())
    exit(-2);
  
  /*
   *  If creating display was successful, then initialize interface, etc.
   */

  current_input[0] = '\0';
  
#ifdef LOG_USAGE
  log_startup("olh_tty");
#endif
  create_windows();
  init_hash_table();
  
  code = menu_init(NULL);
  if (code) {
    printf("For some reason, OLH was not able to load its initial menus.\n");
#ifdef ATHENA
    printf("If you continue to have trouble, please ask a user consultant for help\n");
    printf("via `olc' or by calling 253-4435.\n");
#endif /* ATHENA */
    printf("The error was:\n");
    com_err(program,code,"in menu_init");
    curses_shutdown();
    exit(1);
  }
  e = find_group("main");
  code = menu_load(e, &m);
  if (code) {
    com_err(program, code, "loading main menu");
    curses_shutdown();
    exit(1);
  }
  current_menu = 0;
  menu[current_menu] = m;
  menu_entry[current_menu] = e;
  current[current_menu] = 0;
  viewed[current_menu] = FALSE;
  add_to_menupath(e);
  
  paint_windows();
  show_message(COPYRIGHT);
  hist_on = FALSE;
  
  /*
   * Go into MainLoop.  This does not exit.  Rather, the user exits the
   *  program by pressing "q" or through some other action.
   */

  olh_attach_hook = attach_hook;
  olh_attach_done_hook = attach_done_hook;
  if (argc > 1)
    do_keyword_startup(argv[1]);
  MainLoop();
  curses_shutdown();
  exit(0);
}


void
MainLoop()
{
  int done = FALSE;
  int token, high, number;
  char buffer[SMALL_BUFFER];
  
  /*  Display the primary screen.  */
  
  set_current_screen(SCR_PRIM);
  
  while (! done)
    {
      token = get_token("Number: ");
      
      switch (token)
	{
	case TOKEN_NONE:
	  break;
	  
	case TOKEN_EXIT:
	  done = TRUE;
	  break;
	  
	case TOKEN_UP:
	  up_to_prev_menu();
	  break;
	  
	case TOKEN_TOP:
	  while(current_menu > 0) {
	    current_menu--;
	    del_last_menupath();
	  }
	  doing_keywords = 0;
	  keyword_level = 0;
	  selection = current[current_menu];
	  OLH_ui_update_menus();
	  update_instructions();
	  break;

	case TOKEN_ABOVE:
	  scroll_above();
	  break;
	  
	case TOKEN_BELOW:
	  scroll_below();
	  break;
	  
	case TOKEN_HELP:
	  if (doing_keywords)
	    OLH_ui_help_keyword();
	  else
	    OLH_ui_help_primary();
	  break;
	  
	case TOKEN_SUGGEST:
	  take_bug_or_suggest(OLH_SUGGEST);
	  break;
	  
	case TOKEN_BUG:
	  take_bug_or_suggest(OLH_BUG);
	  break;

	case TOKEN_OLC:
	  invoke_olc();
	  break;

	case TOKEN_NEXT:
	  select_item(1);
	  if (doing_keywords)
	    invoke_k_item(selection);
	  else
	    invoke_item(selection);
	  break;
	  
	case TOKEN_CURR:
	  if (selection != 0) {
	    if (doing_keywords)
	      invoke_k_item(selection);
	    else
	      invoke_item(selection);
	  }
	  break;
	  
	case TOKEN_PREV:
	  select_item(-1);
	  if (doing_keywords)
	    invoke_k_item(selection);
	  else
	    invoke_item(selection);
	  break;
	  
	case TOKEN_SEL_PREV:
	  select_item(-1);
	  break;
	  
	case TOKEN_SEL_NEXT:
	  select_item(1);
	  break;
	  
	case TOKEN_COPY:
	  copy_module();
	  break;

	case TOKEN_PRINT:
	  print_module();
	  break;

	case TOKEN_INFO:
	  show_info();
	  break;

	case TOKEN_SHOW_PATH:
	  show_context_path();
	  break;

	case TOKEN_SHOW_VERSION:
	  OLH_ui_message(COPYRIGHT);
	  break;
	  
	case TOKEN_KEYWORD:
	  if (!doing_keywords) {
	    keyword_level = current_menu;
	    doing_keywords = 1;
	    display_keyword_menu();
	    update_instructions();
	  }
	  else {
	    number = get_keyword();
	    if (number < 0)
	      break;
	    token = number + TOKEN_NUMBER +1;
	  }

	default:
	  number = token - TOKEN_NUMBER;
	  high = size_menu(menu[current_menu]) - 1;
	  if ((number < 1) || (number > high))
	    {
	      sprintf(buffer, "Please choose a number from 1 to %d.", high);
	      OLH_ui_message(buffer);
	    }
	  else
	    {
	      current[current_menu] = number;
	      if (doing_keywords)
		invoke_k_item(number);
	      else
		invoke_item(number);
	    }
	}
    }
}
