/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/menupath.c,v $
 *	$Id: menupath.c,v 1.2 91/02/05 13:36:03 lwvanels Exp $
 *	$Author: lwvanels $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/menupath.c,v 1.2 91/02/05 13:36:03 lwvanels Exp $";
#endif
#endif

#include <strings.h>
#include "global.h"
#include "menu.h"
#include "menupath.h"

#ifdef __STDC__
# define        P(s) s
#else
# define P(s) ()
#endif

void init_menupath P((void ));
void build_menupath P((MenuEntry *e [], int n ));
void add_to_menupath P((MenuEntry *e ));
void make_parents_menupath P((MenuEntry *e ));
void add_parent_to_menupath P((MenuEntry *e ));
void resize_menupath P((int size ));

extern char *malloc P((unsigned size));
extern char *realloc P((char *ptr, unsigned size));
#undef P


char *menupath;
int mp_size = 0;
static not_init = 1;


void
  init_menupath()
{
  menupath = (char *) malloc(1024);
  mp_size = 1024;
  menupath[0] = '\0';
  not_init = 0;
}

void
  build_menupath(e, n)
MenuEntry *e[];
int n;
{
  int i;
  
  if (not_init) init_menupath();
  menupath[0] = '\0';
  for (i=0; i <= n; i++)
    add_to_menupath(e[i]);
}

void
  add_to_menupath(e)
MenuEntry *e;
{
  char *val;
  
  if (not_init) init_menupath();
  val = field_value(e, POINTER);
  if (strlen(val) + strlen(menupath) + 1 > mp_size) /* add 1 for semicolon */
    {
      mp_size += 1024;
      menupath = (char *) realloc(menupath, mp_size);
    }
  strcat(menupath, ";");
  strcat(menupath, val);
}

void
  make_parents_menupath(e)
MenuEntry *e;
{
  if (not_init) init_menupath();
  menupath[0] = '\0';
  
  add_parent_to_menupath(e);
}

void
  add_parent_to_menupath(e)
MenuEntry *e;
{
  char *val;
  MenuEntry *e2;
  long code;
  
  if (e == NULL)
    e = top_entry;
  
  val = field_value(e, PARENT);
  
  if ((val[0] == '\0') || (strcmp(val, top_pointer) == 0))
    return;
  
  if (strlen(val) + strlen(menupath) + 1 > mp_size) /* add 1 for semicolon */
    {
      mp_size += 1024;
      menupath = (char *) realloc(menupath, mp_size);
    }
  
  if (menupath[0] == '\0')
    sprintf(menupath,";%s",val);
  else {
    /* Move old copy of menupath down, insert new node path at front */
    menupath[strlen(val) + strlen(menupath) +1] = '\0';
    bcopy(menupath, (char *)(menupath + strlen(val)+1),
	  strlen(menupath));
    menupath[0] = PATH_SEP_CHAR;
    bcopy(val,(char *) (menupath+1),strlen(val));
  }

  code = pointerEntry(val, &e2);
  if (code || (!e2))
    e2 = NULL;
  add_parent_to_menupath(e2);
}

void
resize_menupath(size)
     int size;
{
  if (size > mp_size)
    {
      mp_size = size;
      menupath = realloc(menupath, mp_size+1); /* add one for final null */
    }
}

void
del_last_menupath()
{
  char *p;

  p = rindex(menupath, PATH_SEP_CHAR);
  if (p != NULL) *p = '\0';
  return;
}

