/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/screen.c,v $
 *	$Id: screen.c,v 1.3 91/02/11 14:46:07 lwvanels Exp $
 *	$Author: lwvanels $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/screen.c,v 1.3 91/02/11 14:46:07 lwvanels Exp $";
#endif
#endif

#include "olh.h"

void
  OLH_ui_update_menus( )
{
  paint_menu();
  wrefresh(win_label);
  wrefresh(win_above);
  wrefresh(win_entries);
  wrefresh(win_below);
}


void
  OLH_ui_message( str )
char* str;
{
  if ((current_message[0] == '\0') || strcmp(str, current_message))
    {
      strcpy(current_message,str);
      paint_message( );
      wrefresh(win_message);
    }
}

void
up_to_prev_menu( )
{
  if (current_menu == 0)
    {
      show_message(NO_MORE_UP);
      return;
    }
  current_menu--;
  if (current_menu <= keyword_level) {
    doing_keywords = 0;
    keyword_level = 0;
  }
  del_last_menupath();
  selection = current[current_menu];
  current_offset = selection;
  select_item(0);
  OLH_ui_update_menus();
  update_instructions();
}


void
  scroll_above( )
{
  int num_entries = size_menu(menu[current_menu]) - 1;
  int last_entry;

  if (current_offset == 0)
    {
      OLH_ui_message("No topics above.");
      sound_bell();
      return;
    }
  
  current_offset = max(0, current_offset - (menu_lines - 1));
  last_entry  = min(num_entries, current_offset+menu_lines);
  if (selection > last_entry)
    selection = current_offset+1;
  
  if (selection < current_offset+1) {
    selection = menu_lines+current_offset+1;
    if (selection > last_entry)
      selection = last_entry;
  }
  current[current_menu] = selection;
  OLH_ui_update_menus();
}

void
  scroll_below( )
{
  int high = size_menu(menu[current_menu]) - menu_lines - 1;
  int num_entries = size_menu(menu[current_menu]) - 1;
  int last_entry;
  
  if (current_offset >= high)
    {
      OLH_ui_message("No topics below.");
      sound_bell();
      return;
    }
  
  current_offset = min(high, current_offset + (menu_lines - 1));

  last_entry = min(num_entries, current_offset+menu_lines);
  if (selection > last_entry)
    selection = current_offset+1;
  
  if (selection < current_offset+1) {
    selection = menu_lines+current_offset+1;
    if (selection > last_entry)
      selection = last_entry;
  }
  current[current_menu] = selection;
  OLH_ui_update_menus();
}


void
  erase_message( )
{
  current_message[0] = '\0';
  paint_message();
  wrefresh(win_message);
}

void
select_item(num)
int num;
{
  int num_entries = size_menu(menu[current_menu]) - 1;
  int last_entry = min(num_entries, current_offset+menu_lines);
  int high = num_entries - menu_lines;
  int did_scroll = 0;

  if (!selection) {
    wmove(win_entries, current[current_menu]- current_offset -1,0);
    waddch(win_entries, ' ');
    if (num == 1)
      selection = current[current_menu] + 1;
    if (num == -1)
      selection = current[current_menu] - 1;
  }
  else {
    wmove(win_entries, selection- current_offset -1,0);
    waddch(win_entries, ' ');
    selection += num;
  }
  
  if (selection > last_entry) {
    did_scroll = 1;
    if (selection < num_entries)
      current_offset = min(high, current_offset + (menu_lines - 1));
    else {
      selection = 1;
      current_offset = 0;
    }
  }  

  if (selection < current_offset+1) {
    did_scroll = 1;
    if (selection <= 0) {
      selection = num_entries;
      current_offset = max(0,high);
    }
    else
      current_offset = max(0, current_offset - (menu_lines - 1));
      
  }

  current[current_menu] = selection;
  if (did_scroll)
    OLH_ui_update_menus();
  else {
    wmove(win_entries, selection - current_offset - 1, 0);
    waddch(win_entries, '>');
    wrefresh(win_entries);
  }
}

void
  update_instructions( )
{
  if (current_menu == 0)
    current_instr = INSTR_NORMAL_TOP;
  else if (!doing_keywords)
    current_instr = INSTR_NORMAL;
  paint_instructions();
  wrefresh(win_instr);
}

void
  show_message(string)
char *string;
{
  static char *stored = (char *) NULL;
  
  if ((stored == (char *) NULL) || strcmp(string, stored))
    {
      stored = string;
      strcpy(current_message,stored);
      paint_message( );
      wrefresh(win_message);
    }
}
