/**********************************************************************
 * EntryField manipulation module
 *
 * $Author: lwvanels $
 * $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/fields.c,v $
 * $Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/fields.c,v 1.5 91/06/30 18:35:41 lwvanels Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef lint
#ifndef SABER
static char rcsid_fields_c[] = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/fields.c,v 1.5 91/06/30 18:35:41 lwvanels Exp $";
#endif
#endif

#include <stdio.h>
#include <strings.h>
#include <memory.h>
#include <menu.h>

extern int errno;

/****************************************************************
 * field_set
 *
 * Arguments:
 *    entry -- (MenuEntry *) in which to set a field
 *    name -- (char *) name of field to set
 *    value -- (char *) value to which it will be set
 *
 * Returns: (long) error status
 ****************************************************************/

long
field_set(entry, name, value)
     MenuEntry *entry;
     char *name, *value;
{
  register EntryField *f, *stop;

  if (entry->size) {
    /* See if field by name given already exists ... */
    stop = entry->field + entry->size;
    for(f = entry->field; f < stop; f++) {
      if (f->name == name) {
	/* Allocate space for new value */
	if (f->value) {
	  f->value = ResizeString(f->value, value);
	}
	else
	  f->value = NewString(value);
	if (!f->value) return((long) errno);
	strcpy(f->value, value);	/* copy new value */
	return(0L);
      }
    }
  }
  /* ... otherwise add a new field */
  if (entry->size == 0) {
    entry->n_alloc = ENT_A_SIZE;
    entry->field = NewArray(EntryField, entry->n_alloc);
  }
  else {
    if (entry->n_alloc == entry->size) {
      /* time to realloc.. */
      entry->n_alloc += ENT_A_SIZE;
      entry->field = ResizeArray(EntryField, entry->field, entry->n_alloc);
    }
  }
  ++(entry->size);

  if (!entry->field) {
    entry->size = 0;
    return((long) errno);
  }
  f = &(entry->field[entry->size-1]);

  if (!(f->value = NewString(value))) {
/*   free(f->name); */
    (entry->size)--;
    return((long) errno);
  }

  f->name = name;
  strcpy(f->value, value);
  return(0L);
}

/****************************************************************
 * field_value
 *
 * Arguments:
 *    entry -- (MenuEntry *) from which to get field value
 *    name -- (char *) name of field
 *
 * Returns: (char *) value of field
 *    If there is no such field, "" is returned.
 ****************************************************************/

char *
field_value(entry, name)
     MenuEntry *entry;
     char *name;
{
  register EntryField *f, *stop;
  MenuEntry *e;
  char *pointer = NULL;
  long code;

  stop = entry->field + entry->size;
  for(f = entry->field; f < stop; f++) {
    if (f->name == name)
      return(f->value);
    if (f->name == POINTER)
      pointer = f->value;
  }

  /* Retrieve from pointer */
  if (pointer) {
    code = pointerEntry(pointer, &e);
    if (code || (!e)) return("");
    return(field_value(e, name));
  }
  return("");
}

/****************************************************************
 * free_fields
 *
 * Arguments:
 *    entry -- (MenuEntry *) in which fields are to be freed
 ****************************************************************/

void
free_fields(entry)
     MenuEntry *entry;
{
/*  register EntryField *f, *stop;

  stop = entry->field + entry->size;
  for(f = entry->field; f < stop; f++)
    if (f->value) free(f->value);
*/
  entry->n_alloc = 0;
  return;
}
