/**********************************************************************
 * Menu manipulation module
 *
 * $Author: ghudson $
 * $Source: /afs/sipb/project/sipb-athena/src/olh/libmenu/RCS/menu.c,v $
 * $Header: /afs/sipb/project/sipb-athena/src/olh/libmenu/RCS/menu.c,v 1.4 1996/03/18 00:40:01 ghudson Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef lint
#ifndef SABER
static char rcsid_menu_c[] = "$Header: /afs/sipb/project/sipb-athena/src/olh/libmenu/RCS/menu.c,v 1.4 1996/03/18 00:40:01 ghudson Exp $";
#endif
#endif

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <memory.h>
#include <menu.h>

Menu **menus_loaded = NULL;
extern int errno;

/****************************************************************
 * (stubs)
 ****************************************************************/

long
menu_load(e, mp)
     MenuEntry *e;
     Menu **mp;
{
  long code;
  char *filename, *filsys;
  int i;

  /* Load configuration menu if necessary */
  if (!menus_loaded) {
    code = menu_init(NULL);
    if (code) return(code);
  }

  filename = field_value(e, FILE_LOCATION);

  /* See if menu has already been loaded */
  for(i=0; menus_loaded[i] != NULL; i++) {
    if (strcmp(menus_loaded[i]->file, filename) == 0) {
      *mp = menus_loaded[i];
      return(0L);
    }
  }
  
  /* attach filesystems */
  filsys = field_value(e, FILESYSTEM);
  if (*filsys) {
    if (access(filename, F_OK)) {
      code = olh_attach(filsys, 0);
      if (code) return(code);
    }
  }

  if (is_dirhook(e)) {
    if (code = dirhook_file_load(field_value(e, FILE_LOCATION), mp))
      return(code);
    return(field_set((*mp)->entry, NODE_LABEL, field_value(e, NODE_LABEL)));
  }
  return(menu_file_load(field_value(e, FILE_LOCATION), mp));
}

long
main_menu_load(mp)
     Menu **mp;
{
  long code;

  code = menu_init(NULL);
  if (code)
    return(code);
  return(menu_load(find_group("main"), mp));
}

long
menu_init(conf)
     char *conf;
{
  Menu *m;

  initialize_menu_error_table();

  /* Free old menus */
  if (menus_loaded) {
    for (m = *menus_loaded; m != NULL; m++)
      freemenu(m);
/*    free((char *) menus_loaded); */
  }

  menus_loaded = NewArray(Menu *, 1);
  if (!menus_loaded) return((long) errno);
  *menus_loaded = NULL;
  if (conf) return(menu_file_load(conf, &m));
#ifdef CONFIG_FILSYS
  if (access(CONFIG_MENU, F_OK))
    return(olh_attach(CONFIG_FILSYS, 0) || menu_file_load(CONFIG_MENU, &m));
#endif
  return(menu_file_load(CONFIG_MENU, &m));
}

char *
group_file_location(s)
     char *s;
{
  int i;
  long code;

  if (!menus_loaded) {
    code = menu_init(NULL);
    if (code) {
      com_err("libmenu",code,"in menu_init");
      exit(1);
    }
  }
  for(i=0; i < menus_loaded[0]->size; i++)
    if (is_menu(nth_entry(menus_loaded[0], i)))
      if (strcasecmp(field_value(nth_entry(menus_loaded[0], i),
				 NODE_ID), s) == 0)
	return(field_value(nth_entry(menus_loaded[0], i), FILE_LOCATION));
      
  return(s);
}

MenuEntry *
find_group(s)
     char *s;
{
  int i;
  long code;

  if (!menus_loaded) {
    code = menu_init(NULL);
    if (code) {
      com_err("libmenu",code,"in menu_init");
      exit(1);
    }
  }
  for(i=0; i < menus_loaded[0]->size; i++)
    if (is_menu(nth_entry(menus_loaded[0], i)))
      if (strcasecmp(field_value(nth_entry(menus_loaded[0], i),
				 NODE_ID), s) == 0)
	return(nth_entry(menus_loaded[0], i));
  return(NULL);
}
