/**********************************************************************
 * Menu allocation module
 *
 * $Author: lwvanels $
 * $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/menu_alloc.c,v $
 * $Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/menu_alloc.c,v 1.3 91/04/29 11:30:44 lwvanels Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef lint
#ifndef SABER
static char rcsid_menu_alloc_c[] = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/menu_alloc.c,v 1.3 91/04/29 11:30:44 lwvanels Exp $";
#endif
#endif

#include <errno.h>
#include <memory.h>
#include <menu.h>

long
newmenu(mp)
     Menu **mp;
{
  if ((*mp = New(Menu)) == NULL) return((long) errno);
  bzero(*mp, sizeof(Menu));
  return(0L);
}

void
freemenu(m)
     Menu *m;
{
  int i;

  for(i=0; i < m->size; i++)
    free_fields(nth_entry(m, i));
/*
  if (m->id) free(m->id);
  if (m->file) free(m->file);
  free(m);
*/
  return;
}

long
resizemenu(m, n)
     Menu *m;
     int n;
{
  int i;

  if (!m->size) {
    if (m->n_alloc == 0) {
      m->n_alloc = MENU_A_SIZE;
      m->entry = NewArray(MenuEntry, m->n_alloc);
    }
    else {
      if (m->n_alloc < n) {
	m->n_alloc = n;
	m->entry = ResizeArray(MenuEntry, m->entry, m->n_alloc);
      }
    }
  }
  else {
    for(i = n; i < m->size; i++)
      free_fields(nth_entry(m, i));
    m->entry = ResizeArray(MenuEntry, m->entry, n);
    m->n_alloc =n;
  }
  if (!m->entry) {
    m->size = 0;
    return((long) errno);
  }
  if (n > m->size)
    bzero(nth_entry(m, m->size), sizeof(MenuEntry)*(n - m->size));
  m->size = n;
  return(0L);
}

long
insertentry(m, n)
     Menu *m;
     int n;
{
  long code;

  code = resizemenu(m, m->size + 1);
  if (code) return(code);
  bcopy(nth_entry(m, n), nth_entry(m, n+1), (m->size-n+1)*sizeof(MenuEntry));
  bzero(nth_entry(m, n), sizeof(MenuEntry)); /* necessary -- trust me */
  return(0L);
}

long
deleteentry(m, n)
     Menu *m;
     int n;
{
  long code;

  free_fields(nth_entry(m, n));
  bcopy(nth_entry(m, n+1), nth_entry(m, n), (m->size-n-1)*sizeof(MenuEntry));
  code = resizemenu(m, m->size - 1);
  if (code) return(code);
  return(0L);
}
