/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.bin/olh/motif/RCS/Context.c,v $
 *      $Id: Context.c,v 1.2 92/12/04 15:48:16 mar Exp $
 *      $Author: mar $
 */

#include <Xm/Xm.h>
#include <Xm/PushB.h>

#include "global.h"
#include "widget_num.h"
#include "menu.h"
#include "menupath.h"

long
ConstructContext(p)
     char *p;
{
  MenuEntry *e;
  Menu *m;
  char *ptr, *end, *def;
  char *path;
  int n;
  long code;
  Arg arg;
  int curr_menu = 0;

  W = NULL;

  for (n=1; menu_btn[n] != (Widget) NULL; n++);

  if (n - 1)
    XtUnmanageChildren(menu_btn + 1, n - 1);

  path = XtNewString(p);
  n = strlen(path);
  if (path[n-1] == '\n')
    {
      n--;
      path[n] = '\0';
    }

  for ( ptr = path+1; ptr - path <= n; ptr = end+1)
    {
      if ((end = index(ptr, PATH_SEP_CHAR)) == NULL)
	end = path + n;
      *end = '\0';

      code = pointerEntry(ptr, &e);
      if (code || (!e))
	{
	  com_err(program, code, "reconstructing path", "");
	  XtFree(path);
	  return(1);
	}
      if (is_menu(e))
	{
	  code = menu_load(e, &m);
	  if (code)
	    {
	      com_err(program, code, "loading menu", "");
	      XtFree(path);
	      return(1);
	    }
	  menu[curr_menu] = m;
	  current[curr_menu] = 0;
	  viewed[curr_menu] = FALSE;
	  if (curr_menu)	/* figure out current in menu above */
	    {
	      Menu *prev_menu;
	      MenuEntry *prev_menu_entry;
	      int i;

	      prev_menu = menu[curr_menu-1];
	      for (i = 0; i < size_menu(prev_menu); i++)
		{
		  prev_menu_entry = nth_entry(prev_menu, i+1);
		  if (!strcmp(field_value(prev_menu_entry, FILE_LOCATION),
			      field_value(e, FILE_LOCATION)))
		    {
		      current[curr_menu-1] = i+1;
		      viewed[curr_menu-1] = TRUE;
		      break;
		    }
		}
	    }
	  XtSetArg(arg, XmNlabelString,
		   MOTIF_STRING(field_value(nth_entry(m, 0), NODE_LABEL)));
	  if (menu_btn[curr_menu] == (Widget) NULL)
	    {
	      W = menu_btn[curr_menu] = XtCreateManagedWidget("temp",
						     xmPushButtonWidgetClass,
						     w[MENU_MENU], &arg, 1);
	      XtAddCallback(W, XmNactivateCallback, menu_callback,
			    curr_menu);
	    }
	  else
	    {
	      XtSetValues(menu_btn[curr_menu], &arg, 1);
	      XtManageChild(menu_btn[curr_menu]);
	      W = menu_btn[curr_menu];
	    }

	  curr_menu++;
	}

#define is_plain_text(e) \
      (!strcasecmp("plain_text", field_value((e), FILE_FORMAT)) \
       || !strcmp("", field_value((e), FILE_FORMAT)))

      if (is_doc(e))
	{
#ifdef HIDDEN
	  XmListAddItemUnselected(w[HIST_LIST],
				  MOTIF_STRING(field_value(e, NODE_LABEL)),
				  0);
	  XmListSetBottomPos(w[HIST_LIST], 0);
#endif /* HIDDEN */
	  if (is_plain_text(e))
	    {
	      viewFile(doc_string(e), field_value(e, NODE_LABEL));
	    }
	  else
	    {
	      if ((def = GetDefault(XtDisplay(w[TOPLEVEL]), "Olh", "wait.viewer"))
		  != NULL)
		show_message(def);
	      viewdoc(e, X, NULL);
	    }
	}
    }

  if (W != NULL)
    {
      Widget old;

      XtSetArg(arg, XmNmenuHistory, &old);
      XtGetValues(w[MENU_OPT], &arg, 1);

      /* This is gross.  Have to swap the menuHistory for a sec, then */
      /* back, so that Motif wakes up and notices that the label has */
      /* changed. */

      if (old == W)
	{
	  XtSetArg(arg, XmNmenuHistory, menu_btn[0]);
	  XtUnmanageChild(w[MENU_OPT]);
	  XtSetValues(w[MENU_OPT], &arg, 1);
	  XtManageChild(w[MENU_OPT]);
	}
      XtSetArg(arg, XmNmenuHistory, W);
      XtUnmanageChild(w[MENU_OPT]);
      XtSetValues(w[MENU_OPT], &arg, 1);
      XtManageChild(w[MENU_OPT]);
    }

  if (curr_menu)
    {
      current_menu = curr_menu-1;
      if (current_menu != 0)
	XtSetSensitive(w[UP_BTN],TRUE);
      else
	XtSetSensitive(w[UP_BTN],FALSE);
      do_menu(menu[current_menu]);
    }

  XtFree(path);
  return(0);
}
