% lib/troff.font/chartab.inc
% Copyright (c) 1985,1986,1987 Adobe Systems Incorporated. All rights reserved.
% GOVERNMENT END USERS: See Notice file in TranScript library directory
% -- probably /usr/lib/ps/Notice
% RCSID: $Header: /afs/dev.mit.edu/source/src80/third/unsupported/transcript-v2.1/lib/troff.font/RCS/chartab.inc,v 1.1 1994/09/18 05:38:48 cfields Exp $
%
% This is the standard character correspondence table for Adobe fonts.
% Font correspondence mapping for Troff and PostScript Bookman family.
%
% PostScript is a registered trademark of Adobe Systems Incorporated.
% TranScript is a trademark of Adobe Systems Incorporated.
%
% This file specifies a correspondence table for the troff (C/A/T)
% to PostScript translator.
% It gets "included" into files that will be read by pscatmap(8).

@BEGINMAP
%Troff	CAT  WID  ACTION  X   Y  Font    char   description
0040  R    0  12  0       0   0  0           0  "space" 
0040  I    0  12  0       0   0  0           0  "ital space" 
0040  B    0  12  0       0   0  0           0  "bold space" 
0041  R 0145  -1  PFONT   0   0  ROMAN    0041  "exclamation" 
0041  I 0145  -1  PFONT   0   0  ITALIC   0041  "ital exclamation" 
0041  B 0145  -1  PFONT   0   0  BOLD     0041  "bold exclamation" 
0042  S 0030  -1  PFONT   0   0  EXTRAS   0042  "double quote" 
0043  S 0137  -1  PFONT   0   0  SYMBOL   0043  "number" 
0044  R 0155  -1  PFONT   0   0  ROMAN    0044  "dollar" 
0044  I 0155  -1  PFONT   0   0  ITALIC   0044  "ital dollar" 
0044  B 0155  -1  PFONT   0   0  BOLD     0044  "bold dollar" 
0045  R 0053  -1  PFONT   0   0  ROMAN    0045  "percent" 
0045  I 0053  -1  PFONT   0   0  ITALIC   0045  "ital percent" 
0045  B 0053  -1  PFONT   0   0  BOLD     0045  "bold percent" 
0046  R 0050  -1  PFONT   0   0  ROMAN    0046  "ampersand" 
0046  I 0050  -1  PFONT   0   0  ITALIC   0046  "ital ampersand" 
0046  B 0050  -1  PFONT   0   0  BOLD     0046  "bold ampersand" 
0047  R 0032  -1  PFONT   0   0  ROMAN    0047  "close quote" 
0047  I 0032  -1  PFONT   0   0  ITALIC   0047  "ital close quote" 
0047  B 0032  -1  PFONT   0   0  BOLD     0047  "bold close quote" 
0050  R 0132  -1  PFONT   0   0  ROMAN    0050  "left paren" 
0050  I 0132  -1  PFONT   0   0  ITALIC   0050  "ital left paren" 
0050  B 0132  -1  PFONT   0   0  BOLD     0050  "bold left paren" 
0051  R 0133  -1  PFONT   0   0  ROMAN    0051  "right paren" 
0051  I 0133  -1  PFONT   0   0  ITALIC   0051  "ital right paren" 
0051  B 0133  -1  PFONT   0   0  BOLD     0051  "bold right paren" 
0052  R 0122  -1  PFONT   0   0  ROMAN    0052  "asterisk" 
0052  I 0122  -1  PFONT   0   0  ITALIC   0052  "ital asterisk" 
0052  B 0122  -1  PFONT   0   0  BOLD     0052  "bold asterisk" 
0053  R 0143  -1  PFONT   0   0  ROMAN    0053  "plus" 
0053  I 0143  -1  PFONT   0   0  ITALIC   0053  "ital plus" 
0053  B 0143  -1  PFONT   0   0  BOLD     0053  "bold plus" 
0054  R 0047  -1  PFONT   0   0  ROMAN    0054  "comma" 
0054  I 0047  -1  PFONT   0   0  ITALIC   0054  "ital comma" 
0054  B 0047  -1  PFONT   0   0  BOLD     0054  "bold comma" 
0055  R 0040  -1  PFONT   0   0  ROMAN    0055  "- hyphen" 
0055  I 0040  -1  PFONT   0   0  ITALIC   0055  "ital - hyphen" 
0055  B 0040  -1  PFONT   0   0  BOLD     0055  "bold - hyphen" 
0056  R 0044  -1  PFONT   0   0  ROMAN    0056  "period" 
0056  I 0044  -1  PFONT   0   0  ITALIC   0056  "ital period" 
0056  B 0044  -1  PFONT   0   0  BOLD     0056  "bold period" 
0057  R 0043  -1  PFONT   0   0  ROMAN    0057  "slash" 
0057  I 0043  -1  PFONT   0   0  ROMAN    0057  "ital slash (roman)" 
0057  B 0043  -1  PFONT   0   0  BOLD     0057  "bold slash" 
0060  R 0110  -1  PFONT   0   0  ROMAN    0060  "0" 
0060  I 0110  -1  PFONT   0   0  ITALIC   0060  "ital 0" 
0060  B 0110  -1  PFONT   0   0  BOLD     0060  "bold 0" 
0061  R 0111  -1  PFONT   0   0  ROMAN    0061  "1" 
0061  I 0111  -1  PFONT   0   0  ITALIC   0061  "ital 1" 
0061  B 0111  -1  PFONT   0   0  BOLD     0061  "bold 1" 
0062  R 0112  -1  PFONT   0   0  ROMAN    0062  "2" 
0062  I 0112  -1  PFONT   0   0  ITALIC   0062  "ital 2" 
0062  B 0112  -1  PFONT   0   0  BOLD     0062  "bold 2" 
0063  R 0113  -1  PFONT   0   0  ROMAN    0063  "3" 
0063  I 0113  -1  PFONT   0   0  ITALIC   0063  "ital 3" 
0063  B 0113  -1  PFONT   0   0  BOLD     0063  "bold 3" 
0064  R 0114  -1  PFONT   0   0  ROMAN    0064  "4" 
0064  I 0114  -1  PFONT   0   0  ITALIC   0064  "ital 4" 
0064  B 0114  -1  PFONT   0   0  BOLD     0064  "bold 4" 
0065  R 0115  -1  PFONT   0   0  ROMAN    0065  "5" 
0065  I 0115  -1  PFONT   0   0  ITALIC   0065  "ital 5" 
0065  B 0115  -1  PFONT   0   0  BOLD     0065  "bold 5" 
0066  R 0116  -1  PFONT   0   0  ROMAN    0066  "6" 
0066  I 0116  -1  PFONT   0   0  ITALIC   0066  "ital 6" 
0066  B 0116  -1  PFONT   0   0  BOLD     0066  "bold 6" 
0067  R 0117  -1  PFONT   0   0  ROMAN    0067  "7" 
0067  I 0117  -1  PFONT   0   0  ITALIC   0067  "ital 7" 
0067  B 0117  -1  PFONT   0   0  BOLD     0067  "bold 7" 
0070  R 0120  -1  PFONT   0   0  ROMAN    0070  "8" 
0070  I 0120  -1  PFONT   0   0  ITALIC   0070  "ital 8" 
0070  B 0120  -1  PFONT   0   0  BOLD     0070  "bold 8" 
0071  R 0121  -1  PFONT   0   0  ROMAN    0071  "9" 
0071  I 0121  -1  PFONT   0   0  ITALIC   0071  "ital 9" 
0071  B 0121  -1  PFONT   0   0  BOLD     0071  "bold 9" 
0072  R 0142  -1  PFONT   0   0  ROMAN    0072  "colon" 
0072  I 0142  -1  PFONT   0   0  ITALIC   0072  "ital colon" 
0072  B 0142  -1  PFONT   0   0  BOLD     0072  "bold colon" 
0073  R 0023  -1  PFONT   0   0  ROMAN    0073  "semicolon" 
0073  I 0023  -1  PFONT   0   0  ITALIC   0073  "ital semicolon" 
0073  B 0023  -1  PFONT   0   0  BOLD     0073  "bold semicolon" 
0074  S 0103  -1  PFONT   0   0  SYMBOL   0074  "less than" 
0075  R 0140  -1  PFONT   0   0  ROMAN    0075  "equal" 
0075  I 0140  -1  PFONT   0   0  ITALIC   0075  "ital equal" 
0075  B 0140  -1  PFONT   0   0  BOLD     0075  "bold equal" 
0076  S 0101  -1  PFONT   0   0  SYMBOL   0076  "greater than" 
0077  R 0147  -1  PFONT   0   0  ROMAN    0077  "question" 
0077  I 0147  -1  PFONT   0   0  ITALIC   0077  "ital question" 
0077  B 0147  -1  PFONT   0   0  BOLD     0077  "bold question" 
0100  S 0022  -1  PFONT   0   0  EXTRAS   0100  "at" 
0101  R 0103  -1  PFONT   0   0  ROMAN    0101  "A" 
0101  I 0103  -1  PFONT   0   0  ITALIC   0101  "ital A" 
0101  B 0103  -1  PFONT   0   0  BOLD     0101  "bold A" 
0102  R 0075  -1  PFONT   0   0  ROMAN    0102  "B" 
0102  I 0075  -1  PFONT   0   0  ITALIC   0102  "ital B" 
0102  B 0075  -1  PFONT   0   0  BOLD     0102  "bold B" 
0103  R 0070  -1  PFONT   0   0  ROMAN    0103  "C" 
0103  I 0070  -1  PFONT   0   0  ITALIC   0103  "ital C" 
0103  B 0070  -1  PFONT   0   0  BOLD     0103  "bold C" 
0104  R 0074  -1  PFONT   0   0  ROMAN    0104  "D" 
0104  I 0074  -1  PFONT   0   0  ITALIC   0104  "ital D" 
0104  B 0074  -1  PFONT   0   0  BOLD     0104  "bold D" 
0105  R 0072  -1  PFONT   0   0  ROMAN    0105  "E" 
0105  I 0072  -1  PFONT   0   0  ITALIC   0105  "ital E" 
0105  B 0072  -1  PFONT   0   0  BOLD     0105  "bold E" 
0106  R 0101  -1  PFONT   0   0  ROMAN    0106  "F" 
0106  I 0101  -1  PFONT   0   0  ITALIC   0106  "ital F" 
0106  B 0101  -1  PFONT   0   0  BOLD     0106  "bold F" 
0107  R 0065  -1  PFONT   0   0  ROMAN    0107  "G" 
0107  I 0065  -1  PFONT   0   0  ITALIC   0107  "ital G" 
0107  B 0065  -1  PFONT   0   0  BOLD     0107  "bold G" 
0110  R 0060  -1  PFONT   0   0  ROMAN    0110  "H" 
0110  I 0060  -1  PFONT   0   0  ITALIC   0110  "ital H" 
0110  B 0060  -1  PFONT   0   0  BOLD     0110  "bold H" 
0111  R 0066  -1  PFONT   0   0  ROMAN    0111  "I" 
0111  I 0066  -1  PFONT   0   0  ITALIC   0111  "ital I" 
0111  B 0066  -1  PFONT   0   0  BOLD     0111  "bold I" 
0112  R 0105  -1  PFONT   0   0  ROMAN    0112  "J" 
0112  I 0105  -1  PFONT   0   0  ITALIC   0112  "ital J" 
0112  B 0105  -1  PFONT   0   0  BOLD     0112  "bold J" 
0113  R 0107  -1  PFONT   0   0  ROMAN    0113  "K" 
0113  I 0107  -1  PFONT   0   0  ITALIC   0113  "ital K" 
0113  B 0107  -1  PFONT   0   0  BOLD     0113  "bold K" 
0114  R 0063  -1  PFONT   0   0  ROMAN    0114  "L" 
0114  I 0063  -1  PFONT   0   0  ITALIC   0114  "ital L" 
0114  B 0063  -1  PFONT   0   0  BOLD     0114  "bold L" 
0115  R 0062  -1  PFONT   0   0  ROMAN    0115  "M" 
0115  I 0062  -1  PFONT   0   0  ITALIC   0115  "ital M" 
0115  B 0062  -1  PFONT   0   0  BOLD     0115  "bold M" 
0116  R 0061  -1  PFONT   0   0  ROMAN    0116  "N" 
0116  I 0061  -1  PFONT   0   0  ITALIC   0116  "ital N" 
0116  B 0061  -1  PFONT   0   0  BOLD     0116  "bold N" 
0117  R 0057  -1  PFONT   0   0  ROMAN    0117  "O" 
0117  I 0057  -1  PFONT   0   0  ITALIC   0117  "ital O" 
0117  B 0057  -1  PFONT   0   0  BOLD     0117  "bold O" 
0120  R 0067  -1  PFONT   0   0  ROMAN    0120  "P" 
0120  I 0067  -1  PFONT   0   0  ITALIC   0120  "ital P" 
0120  B 0067  -1  PFONT   0   0  BOLD     0120  "bold P" 
0121  R 0055  -1  PFONT   0   0  ROMAN    0121  "Q" 
0121  I 0055  -1  PFONT   0   0  ITALIC   0121  "ital Q" 
0121  B 0055  -1  PFONT   0   0  BOLD     0121  "bold Q" 
0122  R 0064  -1  PFONT   0   0  ROMAN    0122  "R" 
0122  I 0064  -1  PFONT   0   0  ITALIC   0122  "ital R" 
0122  B 0064  -1  PFONT   0   0  BOLD     0122  "bold R" 
0123  R 0076  -1  PFONT   0   0  ROMAN    0123  "S" 
0123  I 0076  -1  PFONT   0   0  ITALIC   0123  "ital S" 
0123  B 0076  -1  PFONT   0   0  BOLD     0123  "bold S" 
0124  R 0056  -1  PFONT   0   0  ROMAN    0124  "T" 
0124  I 0056  -1  PFONT   0   0  ITALIC   0124  "ital T" 
0124  B 0056  -1  PFONT   0   0  BOLD     0124  "bold T" 
0125  R 0106  -1  PFONT   0   0  ROMAN    0125  "U" 
0125  I 0106  -1  PFONT   0   0  ITALIC   0125  "ital U" 
0125  B 0106  -1  PFONT   0   0  BOLD     0125  "bold U" 
0126  R 0071  -1  PFONT   0   0  ROMAN    0126  "V" 
0126  I 0071  -1  PFONT   0   0  ITALIC   0126  "ital V" 
0126  B 0071  -1  PFONT   0   0  BOLD     0126  "bold V" 
0127  R 0104  -1  PFONT   0   0  ROMAN    0127  "W" 
0127  I 0104  -1  PFONT   0   0  ITALIC   0127  "ital W" 
0127  B 0104  -1  PFONT   0   0  BOLD     0127  "bold W" 
0130  R 0102  -1  PFONT   0   0  ROMAN    0130  "X" 
0130  I 0102  -1  PFONT   0   0  ITALIC   0130  "ital X" 
0130  B 0102  -1  PFONT   0   0  BOLD     0130  "bold X" 
0131  R 0077  -1  PFONT   0   0  ROMAN    0131  "Y" 
0131  I 0077  -1  PFONT   0   0  ITALIC   0131  "ital Y" 
0131  B 0077  -1  PFONT   0   0  BOLD     0131  "bold Y" 
0132  R 0073  -1  PFONT   0   0  ROMAN    0132  "Z" 
0132  I 0073  -1  PFONT   0   0  ITALIC   0132  "ital Z" 
0132  B 0073  -1  PFONT   0   0  BOLD     0132  "bold Z" 
0133  R 0134  -1  PFONT   0   0  ROMAN    0133  "left bracket" 
0133  I 0134  -1  PFONT   0   0  ITALIC   0133  "ital left bracket" 
0133  B 0134  -1  PFONT   0   0  BOLD     0133  "bold left bracket" 
0134  S 0041  -1  PFONT   0   0  EXTRAS   0134  "backslash" 
0135  R 0135  -1  PFONT   0   0  ROMAN    0135  "right bracket" 
0135  I 0135  -1  PFONT   0   0  ITALIC   0135  "ital right bracket" 
0135  B 0135  -1  PFONT   0   0  BOLD     0135  "bold right bracket" 
0136  S 0136  -1  PFONT   0   0  EXTRAS   0303  "circumflex" 
0137  S 0040  -1  PFONT   0   0  EXTRAS   0137  "underscore" 
0140  R 0030  -1  PFONT   0   0  ROMAN    0140  "open quote" 
0140  I 0030  -1  PFONT   0   0  ITALIC   0140  "ital open quote" 
0140  B 0030  -1  PFONT   0   0  BOLD     0140  "bold open quote" 
0141  R 0025  -1  PFONT   0   0  ROMAN    0141  "a" 
0141  I 0025  -1  PFONT   0   0  ITALIC   0141  "ital a" 
0141  B 0025  -1  PFONT   0   0  BOLD     0141  "bold a" 
0142  R 0012  -1  PFONT   0   0  ROMAN    0142  "b" 
0142  I 0012  -1  PFONT   0   0  ITALIC   0142  "ital b" 
0142  B 0012  -1  PFONT   0   0  BOLD     0142  "bold b" 
0143  R 0027  -1  PFONT   0   0  ROMAN    0143  "c" 
0143  I 0027  -1  PFONT   0   0  ITALIC   0143  "ital c" 
0143  B 0027  -1  PFONT   0   0  BOLD     0143  "bold c" 
0144  R 0011  -1  PFONT   0   0  ROMAN    0144  "d" 
0144  I 0011  -1  PFONT   0   0  ITALIC   0144  "ital d" 
0144  B 0011  -1  PFONT   0   0  BOLD     0144  "bold d" 
0145  R 0031  -1  PFONT   0   0  ROMAN    0145  "e" 
0145  I 0031  -1  PFONT   0   0  ITALIC   0145  "ital e" 
0145  B 0031  -1  PFONT   0   0  BOLD     0145  "bold e" 
0146  R 0014  -1  PFONT   0   0  ROMAN    0146  "f" 
0146  I 0014  -1  PFONT   0   0  ITALIC   0146  "ital f" 
0146  B 0014  -1  PFONT   0   0  BOLD     0146  "bold f" 
0147  R 0045  -1  PFONT   0   0  ROMAN    0147  "g" 
0147  I 0045  -1  PFONT   0   0  ITALIC   0147  "ital g" 
0147  B 0045  -1  PFONT   0   0  BOLD     0147  "bold g" 
0150  R 0001  -1  PFONT   0   0  ROMAN    0150  "h" 
0150  I 0001  -1  PFONT   0   0  ITALIC   0150  "ital h" 
0150  B 0001  -1  PFONT   0   0  BOLD     0150  "bold h" 
0151  R 0006  -1  PFONT   0   0  ROMAN    0151  "i" 
0151  I 0006  -1  PFONT   0   0  ITALIC   0151  "ital i" 
0151  B 0006  -1  PFONT   0   0  BOLD     0151  "bold i" 
0152  R 0015  -1  PFONT   0   0  ROMAN    0152  "j" 
0152  I 0015  -1  PFONT   0   0  ITALIC   0152  "ital j" 
0152  B 0015  -1  PFONT   0   0  BOLD     0152  "bold j" 
0153  R 0017  -1  PFONT   0   0  ROMAN    0153  "k" 
0153  I 0017  -1  PFONT   0   0  ITALIC   0153  "ital k" 
0153  B 0017  -1  PFONT   0   0  BOLD     0153  "bold k" 
0154  R 0005  -1  PFONT   0   0  ROMAN    0154  "l" 
0154  I 0005  -1  PFONT   0   0  ITALIC   0154  "ital l" 
0154  B 0005  -1  PFONT   0   0  BOLD     0154  "bold l" 
0155  R 0004  -1  PFONT   0   0  ROMAN    0155  "m" 
0155  I 0004  -1  PFONT   0   0  ITALIC   0155  "ital m" 
0155  B 0004  -1  PFONT   0   0  BOLD     0155  "bold m" 
0156  R 0003  -1  PFONT   0   0  ROMAN    0156  "n" 
0156  I 0003  -1  PFONT   0   0  ITALIC   0156  "ital n" 
0156  B 0003  -1  PFONT   0   0  BOLD     0156  "bold n" 
0157  R 0033  -1  PFONT   0   0  ROMAN    0157  "o" 
0157  I 0033  -1  PFONT   0   0  ITALIC   0157  "ital o" 
0157  B 0033  -1  PFONT   0   0  BOLD     0157  "bold o" 
0160  R 0021  -1  PFONT   0   0  ROMAN    0160  "p" 
0160  I 0021  -1  PFONT   0   0  ITALIC   0160  "ital p" 
0160  B 0021  -1  PFONT   0   0  BOLD     0160  "bold p" 
0161  R 0042  -1  PFONT   0   0  ROMAN    0161  "q" 
0161  I 0042  -1  PFONT   0   0  ITALIC   0161  "ital q" 
0161  B 0042  -1  PFONT   0   0  BOLD     0161  "bold q" 
0162  R 0035  -1  PFONT   0   0  ROMAN    0162  "r" 
0162  I 0035  -1  PFONT   0   0  ITALIC   0162  "ital r" 
0162  B 0035  -1  PFONT   0   0  BOLD     0162  "bold r" 
0163  R 0010  -1  PFONT   0   0  ROMAN    0163  "s" 
0163  I 0010  -1  PFONT   0   0  ITALIC   0163  "ital s" 
0163  B 0010  -1  PFONT   0   0  BOLD     0163  "bold s" 
0164  R 0002  -1  PFONT   0   0  ROMAN    0164  "t" 
0164  I 0002  -1  PFONT   0   0  ITALIC   0164  "ital t" 
0164  B 0002  -1  PFONT   0   0  BOLD     0164  "bold t" 
0165  R 0016  -1  PFONT   0   0  ROMAN    0165  "u" 
0165  I 0016  -1  PFONT   0   0  ITALIC   0165  "ital u" 
0165  B 0016  -1  PFONT   0   0  BOLD     0165  "bold u" 
0166  R 0037  -1  PFONT   0   0  ROMAN    0166  "v" 
0166  I 0037  -1  PFONT   0   0  ITALIC   0166  "ital v" 
0166  B 0037  -1  PFONT   0   0  BOLD     0166  "bold v" 
0167  R 0041  -1  PFONT   0   0  ROMAN    0167  "w" 
0167  I 0041  -1  PFONT   0   0  ITALIC   0167  "ital w" 
0167  B 0041  -1  PFONT   0   0  BOLD     0167  "bold w" 
0170  R 0013  -1  PFONT   0   0  ROMAN    0170  "x" 
0170  I 0013  -1  PFONT   0   0  ITALIC   0170  "ital x" 
0170  B 0013  -1  PFONT   0   0  BOLD     0170  "bold x" 
0171  R 0051  -1  PFONT   0   0  ROMAN    0171  "y" 
0171  I 0051  -1  PFONT   0   0  ITALIC   0171  "ital y" 
0171  B 0051  -1  PFONT   0   0  BOLD     0171  "bold y" 
0172  R 0007  -1  PFONT   0   0  ROMAN    0172  "z" 
0172  I 0007  -1  PFONT   0   0  ITALIC   0172  "ital z" 
0172  B 0007  -1  PFONT   0   0  BOLD     0172  "bold z" 
0173  S 0132  -1  PFONT   0   0  EXTRAS   0173  "left brace" 
0174  R 0151  -1  PFONT   0   0  DEFSYM   0145  "vert bar" 
0174  I 0151  -1  PFONT   0   0  DEFSYM   0145  "vert bar" 
0174  B 0151  -1  PFONT   0   0  DEFSYM   0145  "vert bar" 
0175  S 0133  -1  PFONT   0   0  EXTRAS   0175  "right brace" 
0176  S 0142  18  PFONT   0   0  EXTRAS   0304  "tilde" 
0177  R    0   6  0       0   0  0           0  "narrow space" 
0177  I    0   6  0       0   0  0           0  "ital narrow space" 
0177  B    0   6  0       0   0  0           0  "bold narrow space" 
0200  R 0040  -1  PFONT   0   0  ROMAN    0055  "hyphen" 
0200  I 0040  -1  PFONT   0   0  ITALIC   0055  "ital hyphen" 
0200  B 0040  -1  PFONT   0   0  BOLD     0055  "bold hyphen" 
0201  R 0146  -1  PFONT   0   0  DEFSYM   0147  "bullet" 
0201  I 0146  -1  PFONT   0   0  DEFSYM   0147  "ital bullet" 
0201  B 0146  -1  PFONT   0   0  DEFSYM   0147  "bold bullet" 
0202  R 0154  -1  PFONT   0   0  DEFSYM   0140  "square box" 
0202  I 0154  -1  PFONT   0   0  DEFSYM   0140  "ital square box" 
0202  B 0154  -1  PFONT   0   0  DEFSYM   0140  "bold square box" 
0203  R 0022  -1  PFONT   0   0  ROMAN    0320  "3/4 em-dash" 
0203  I 0022  -1  PFONT   0   0  ITALIC   0320  "ital 3/4 em-dash" 
0203  B 0022  -1  PFONT   0   0  BOLD     0320  "bold 3/4 em-dash" 
0204  R 0026  -1  PFONT   0   0  DEFSYM   0150  "rule" 
0204  I 0026  -1  PFONT   0   0  DEFSYM   0150  "ital rule (roman)" 
0204  B 0026  -1  PFONT   0   0  DEFSYM   0150  "bold rule (roman)" 
0205  R 0034  30  PPROC   0   0  ROMAN    0001  "1/4" 
0205  I 0034  30  PPROC   0   0  ITALIC   0001  "ital 1/4" 
0205  B 0034  30  PPROC   0   0  BOLD     0001  "bold 1/4" 
0206  R 0036  30  PPROC   0   0  ROMAN    0001  "1/2" 
0206  I 0036  30  PPROC   0   0  ITALIC   0001  "ital 1/2" 
0206  B 0036  30  PPROC   0   0  BOLD     0001  "bold 1/2" 
0207  R 0046  30  PPROC   0   0  ROMAN    0001  "3/4" 
0207  I 0046  30  PPROC   0   0  ITALIC   0001  "ital 3/4" 
0207  B 0046  30  PPROC   0   0  BOLD     0001  "bold 3/4" 
0210  R 0123  -1  PFONT   0   0  ROMAN    0261  "minus sign(en)" 
0210  I 0123  -1  PFONT   0   0  ITALIC   0261  "ital minus sign" 
0210  B 0123  -1  PFONT   0   0  BOLD     0261  "bold minus sign" 
0211  R 0124  -1  PFONT   0   0  ROMAN    0256  "fi" 
0211  I 0124  -1  PFONT   0   0  ITALIC   0256  "ital fi" 
0211  B 0124  -1  PFONT   0   0  BOLD     0256  "bold fi" 
0212  R 0125  -1  PFONT   0   0  ROMAN    0257  "fl" 
0212  I 0125  -1  PFONT   0   0  ITALIC   0257  "ital fl" 
0212  B 0125  -1  PFONT   0   0  BOLD     0257  "bold fl" 
0213  R 0126  -1  PLIG    0   0  ROMAN       0  "ff" 
0213  I 0126  -1  PLIG    0   0  ITALIC      0  "ital ff" 
0213  B 0126  -1  PLIG    0   0  BOLD        0  "bold ff" 
0214  R 0131  -1  PLIG    0   0  ROMAN       0  "ffi" 
0214  I 0131  -1  PLIG    0   0  ITALIC      0  "ital ffi" 
0214  B 0131  -1  PLIG    0   0  BOLD        0  "bold ffi" 
0215  R 0130  -1  PLIG    0   0  ROMAN       0  "ffl" 
0215  I 0130  -1  PLIG    0   0  ITALIC      0  "ital ffl" 
0215  B 0130  -1  PLIG    0   0  BOLD        0  "bold ffl" 
0216  R 0136  -1  PFONT   0   0  SYMBOL   0260  "degree" 
0216  I 0136  -1  PFONT   0   0  SYMBOL   0260  "ital degree" 
0216  B 0136  -1  PFONT   0   0  SYMBOL   0260  "bold degree" 
0217  R 0137  -1  PFONT   0   0  ROMAN    0262  "dagger" 
0217  I 0137  -1  PFONT   0   0  ITALIC   0262  "ital dagger" 
0217  B 0137  -1  PFONT   0   0  BOLD     0262  "bold dagger" 
0220  S 0155  -1  PFONT   0   0  EXTRAS   0247  "section" 
0221  R 0150  -1  PFONT   0   0  SYMBOL   0242  "foot mark" 
0221  I 0150  -1  PFONT   0   0  SYMBOL   0242  "ital foot mark" 
0221  B 0150  -1  PFONT   0   0  SYMBOL   0242  "bold foot mark" 
0222  S 0134  12  PFONT   0   0  EXTRAS   0302  "acute accent" 
0223  S 0135  12  PFONT   0   0  EXTRAS   0301  "grave accent" 
0224  S 0040  -1  PFONT   0   0  DEFSYM   0151  "underrule" 
0225  S 0104  -1  PFONT   0   0  SYMBOL   0057  "long slash" 
0226  R    0   3  0       0   0  0           0  "half narrow space" 
0226  I    0   3  0       0   0  0           0  "ital half narrow space" 
0226  B    0   3  0       0   0  0           0  "bold half narrow space" 
0227  R    0   0  0       0   0  0           0  "null" 
0230  S 0025  -1  PFONT   0   0  SYMBOL   0141  "alpha" 
0231  S 0012  -1  PFONT   0   0  SYMBOL   0142  "beta" 
0232  S 0045  -1  PFONT   0   0  SYMBOL   0147  "gamma" 
0233  S 0011  -1  PFONT   0   0  SYMBOL   0144  "delta" 
0234  S 0031  -1  PFONT   0   0  SYMBOL   0145  "epsilon" 
0235  S 0007  -1  PFONT   0   0  SYMBOL   0172  "zeta" 
0236  S 0014  -1  PFONT   0   0  SYMBOL   0150  "eta" 
0237  S 0002  -1  PFONT   0   0  SYMBOL   0161  "theta" 
0240  S 0006  -1  PFONT   0   0  SYMBOL   0151  "iota" 
0241  S 0017  -1  PFONT   0   0  SYMBOL   0153  "kappa" 
0242  S 0005  -1  PFONT   0   0  SYMBOL   0154  "lambda" 
0243  S 0004  -1  PFONT   0   0  SYMBOL   0155  "mu" 
0244  S 0003  -1  PFONT   0   0  SYMBOL   0156  "nu" 
0245  S 0013  -1  PFONT   0   0  SYMBOL   0170  "xi" 
0246  S 0033  -1  PFONT   0   0  SYMBOL   0157  "omicron" 
0247  S 0021  -1  PFONT   0   0  SYMBOL   0160  "pi" 
0250  S 0035  -1  PFONT   0   0  SYMBOL   0162  "rho" 
0251  S 0010  -1  PFONT   0   0  SYMBOL   0163  "sigma" 
0252  S 0037  -1  PFONT   0   0  SYMBOL   0164  "tau" 
0253  S 0016  -1  PFONT   0   0  SYMBOL   0165  "upsilon" 
0254  S 0015  -1  PFONT   0   0  SYMBOL   0146  "phi" 
0255  S 0027  -1  PFONT   0   0  SYMBOL   0143  "chi" 
0256  S 0001  -1  PFONT   0   0  SYMBOL   0171  "psi" 
0257  S 0051  -1  PFONT   0   0  SYMBOL   0167  "omega" 
0260  S 0065  -1  PFONT   0   0  SYMBOL   0107  "Gamma" 
0261  S 0074  -1  PFONT   0   0  SYMBOL   0104  "Delta" 
0262  S 0056  -1  PFONT   0   0  SYMBOL   0121  "Theta" 
0263  S 0063  -1  PFONT   0   0  SYMBOL   0114  "Lambda" 
0264  S 0102  -1  PFONT   0   0  SYMBOL   0130  "Xi" 
0265  S 0067  -1  PFONT   0   0  SYMBOL   0120  "Pi" 
0266  S 0076  -1  PFONT   0   0  SYMBOL   0123  "Sigma" 
0267  R    0   0  0       0   0  0           0  "null" 
0270  S 0106  -1  PFONT   0   0  SYMBOL   0125  "Upsilon" 
0271  S 0055  -1  PFONT   0   0  SYMBOL   0106  "Phi" 
0272  S 0042  -1  PFONT   0   0  SYMBOL   0131  "Psi" 
0273  S 0057  -1  PFONT   0   0  SYMBOL   0127  "Omega" 
0274  S 0075  -1  PFONT   0   5  SYMBOL   0326  "square root" 
0275  S 0062  -1  PFONT   0   0  SYMBOL   0126  "terminal sigma" 
0276  S 0061  -1  PFONT   0   0  DEFSYM   0144  "root en" 
0277  S 0127  -1  PFONT   0   0  SYMBOL   0263  "greater or equal" 
0300  S 0126  -1  PFONT   0   0  SYMBOL   0243  "less or equal" 
0301  S 0130  -1  PFONT   0   0  SYMBOL   0272  "identically equal" 
0302  S 0064  -1  PFONT   0   0  SYMBOL   0055  "equasion minus" 
0303  S 0077  -1  PFONT   0   0  SYMBOL   0100  "approx equal" 
0304  S 0072  -1  PFONT   0   0  SYMBOL   0176  "approximates" 
0305  S 0131  -1  PFONT   0   0  SYMBOL   0271  "not equal" 
0306  S 0154  -1  PFONT   0   0  SYMBOL   0256  "right arrow" 
0307  S 0034  -1  PFONT   0   0  SYMBOL   0254  "left arrow" 
0310  S 0036  -1  PFONT   0   0  SYMBOL   0255  "up arrow" 
0311  S 0023  -1  PFONT   0   0  SYMBOL   0257  "down arrow" 
0312  S 0032  -1  PFONT   0   0  SYMBOL   0075  "equation equal" 
0313  S 0123  -1  PFONT   0   0  SYMBOL   0264  "multiply" 
0314  S 0124  -1  PFONT   0   0  SYMBOL   0270  "divide" 
0315  S 0125  -1  PFONT   0   0  SYMBOL   0261  "plus-minus" 
0316  S 0060  -1  PFONT   0   0  SYMBOL   0310  "cup (union)" 
0317  S 0105  -1  PFONT   0   0  SYMBOL   0307  "cap (intersection)" 
0320  S 0070  -1  PFONT   0   0  SYMBOL   0314  "subset of" 
0321  S 0071  -1  PFONT   0   0  SYMBOL   0311  "superset of" 
0322  S 0150  -1  PFONT   0   0  SYMBOL   0315  "improper subset of" 
0323  S 0046  -1  PFONT   0   0  SYMBOL   0312  "improper superset of" 
0324  S 0044  -1  PFONT   0   0  SYMBOL   0245  "infinity" 
0325  S 0073  -1  PFONT   0   0  SYMBOL   0266  "partial derivative" 
0326  S 0053  -1  PFONT   0   0  SYMBOL   0321  "gradient" 
0327  S 0107  -1  PFONT   0   0  SYMBOL   0330  "logical not" 
0330  S 0066  -1  PFONT   0   6  SYMBOL   0362  "integral" 
0331  S 0047  -1  PFONT   0   0  SYMBOL   0265  "proportional to" 
0332  S 0143  -1  PFONT   0   0  SYMBOL   0306  "empty set" 
0333  S 0141  -1  PFONT   0   0  SYMBOL   0316  "member of" 
0334  S 0153  -1  PFONT   0   0  SYMBOL   0053  "equasion plus" 
0335  R 0141  -1  PFONT   0   0  SYMBOL   0322  "registered" 
0335  I 0141  -1  PFONT   0   0  SYMBOL   0322  "ital registered" 
0335  B 0141  -1  PFONT   0   0  SYMBOL   0322  "bold registered" 
0336  R 0153  -1  PFONT   0   0  SYMBOL   0323  "copyright" 
0336  I 0153  -1  PFONT   0   0  SYMBOL   0323  "ital copyright" 
0336  B 0153  -1  PFONT   0   0  SYMBOL   0323  "bold copyright" 
0337  S 0146  -1  PFONT   0   0  DEFSYM   0143  "box rule" 
0340  R 0127  -1  PFONT   0   0  ROMAN    0242  "cent" 
0340  I 0127  -1  PFONT   0   0  ITALIC   0242  "ital cent" 
0340  B 0127  -1  PFONT   0   0  BOLD     0242  "bold cent" 
0341  S 0145  -1  PFONT   0   0  EXTRAS   0263  "double dagger" 
0342  S 0050  -1  PFONT   0   0  SYMBOL   0336  "right hand (arrow)" 
0343  S 0140  -1  PFONT   0   0  SYMBOL   0334  "left hand (arrow)" 
0344  S 0147  -1  PFONT   0   0  SYMBOL   0052  "math star" 
0345  S 0043  -1  PFONT   0   0  SYMBOL   0360  "?bell? logo" 
0346  S 0026  -1  PFONT   0   0  SYMBOL   0174  "or" 
0347  S 0151  -1  PFONT   0   0  DEFSYM   0142  "circle" 
0350  S 0111  -1  PFONT   0   0  DEFSYM   0111  "lt of big curly" 
0351  S 0114  -1  PFONT   0   0  DEFSYM   0114  "lb of big curly" 
0352  S 0115  -1  PFONT   0   0  DEFSYM   0115  "rt of big curly" 
0353  S 0117  -1  PFONT   0   0  DEFSYM   0117  "rb of big curly" 
0354  S 0113  -1  PFONT   0   0  DEFSYM   0113  "lc of big curly" 
0355  S 0116  -1  PFONT   0   0  DEFSYM   0116  "rc of big curly" 
0356  S 0112  -1  PFONT   0   0  DEFSYM   0112  "bold vertical" 
0357  S 0121  -1  PFONT   0   0  DEFSYM   0121  "left floor" 
0360  S 0120  -1  PFONT   0   0  DEFSYM   0120  "right floor" 
0361  S 0122  -1  PFONT   0   0  DEFSYM   0122  "left ceiling" 
0362  S 0110  -1  PFONT   0   0  DEFSYM   0110  "right ceiling" 
   0  0    0   0  0       0   0  0           0  "THE END"
@ENDMAP
