#! /bin/sh
# sh/psroff.bsd
# Copyright 1985,1987 Adobe Systems Incorporated. All rights reserved.
# GOVERNMENT END USERS: See notice of rights in Notice file in TranScript
# library directory -- probably /usr/lib/ps/Notice
# RCSID: $Header: /afs/dev.mit.edu/source/src80/third/unsupported/transcript-v2.1/sh/RCS/psroff.sh,v 1.5 1990/07/02 15:14:54 epeisach Exp $
#
# run ditroff in an environment to print on a PostScript printer
#
# psroff - ditroff | psdit [| lpr]
#
# Usr /usr/bin/troff -- At Athena ditroff is installed as /usr/bin/troff
PATH=/bin:/usr/bin:$PATH       # Make sure we get system programs.
export PATH

ditroff=troff
psdit=psdit
land=cat
land1=-
nospool= dopt= fil= spool= dit=
printer=-P${PRINTER-PostScript}
family=Times
fontdir=DITDIR
while test $# != 0
do	case "$1" in
	-t)	nospool=1 ;;
	-Tpsc)	;;
	-T*)	echo only -Tpsc is valid 1>&2 ; exit 2 ;;
	-F)	if test "$#" -lt 2 ; then
			echo '-F takes following font family name' 1>&2
			exit 1 
		fi
		family=$2 ; shift ;;
	-F*)	echo 'use -F familyname' 1>&2 ;
		exit 1 ;;
	-D)	if test "$#" -lt 2 ; then
			echo '-D takes following font directory' 1>&2
			exit 1 
		fi
		fontdir=$2 ; shift ;;
	-D*)	echo 'use -D fontdirectory' 1>&2 ;
		exit 1 ;;
	-#*|-h|-m|-z)	spool="$spool $1" ;;
	-P*)	printer=$1
		if [ ${printer}x = -Px ]; then
			printer=-P$2
			shift
		fi;;
	-C)	spool="$spool $1 $2" ; shift ;;
	-J)	spool="$spool $1 $2" ; jobname=$2 ; shift ;;
	-L)	land=sed ; land1="/^\/xi /s/0 72 11 mul translate/90 rotate/" ;;
	-)	fil="$fil $1" ;;
	-*)	dopt="$dopt $1" ;;
	*)	fil="$fil $1" ; jobname=${jobname-$1} ;;
	esac
	shift
done
if test "$jobname" = "" ; then
	spool="-J Ditroff $spool"
fi
spool="lpr $printer $spool"
if test "$fil" = "" ; then
	fil="-"
fi
dit="$ditroff -Tpsc DITFLAGS -F$fontdir/$family $dopt $fil "
psdit="$psdit -F$fontdir/$family"

if test "$nospool" = "1" ; then
	$dit | $psdit | $land "$land1"
else
	$dit | $psdit | $land "$land1" | $spool
fi
