#!/bin/sh
#
# $Id: do_update.sh,v 1.2 1996/06/01 18:58:41 ghudson Exp $
#

ROOT=${ROOT-}; export ROOT

CONFCHG=/tmp/conf.list; export CONFCHG
CONFVARS=/tmp/update.conf; export CONFVARS
CONFDIR="${CONFDIR-/etc/athena}"; export CONFDIR

LIBDIR=${LIBDIR-/srvd/usr/athena/lib/update};  export LIBDIR
PATH=/srvd/bin:/srvd/sbin:/srvd/sbin/srvd/etc/athena:/srvd/bin/athena:/srvd/usr/bin:/srvd/usr/sbin:/srvd/usr/athena/etc:$LIBDIR:/bin:/etc:/usr/bin ; export PATH
MKSERV=/afs/sipb.mit.edu/project/mkserv/arch/${ATHENA_SYS}/bin/mkserv

if [ ! -f ${ROOT}/${CONFDIR}/rc.conf -a -f ${ROOT}/etc/rc.conf ]; then
	CONFDIR=/etc; export CONFDIR
fi

echo "Starting update..."
SERVERDIR=/var/server; export SERVERDIR

if [ "${AFSCLIENT}" = "true" ]; then
public_files="	${public_files} \
		/usr/vice/etc/cacheinfo \
		/usr/vice/etc/SuidCells \
		/usr/vice/etc/ThisCell"
fi

MACH="`uname -s`/`uname -m`"

echo -n "Athena Workstation ($MACH) Version Update" >> ${CONFDIR}/version
date >> ${ROOT}${CONFDIR}/version

echo ""
echo "Backing up rc.conf to rc.conf.old"
rm -f ${ROOT}${CONFDIR}/rc.conf.old
cp -p ${ROOT}${CONFDIR}/rc.conf ${ROOT}${CONFDIR}/rc.conf.old

if [ "${VERSION}" != "${NEWVERS}" ]; then
	echo "Version-specific updating.."
	cp /dev/null ${CONFVARS}
	upvers $VERSION $NEWVERS $LIBDIR
fi

# First let us check for configuration changes
# The version-specific scripts may have set something.
# If it is a public workstation, on the other hand, let us update everything

if [ -f ${ROOT}/etc/athena/rc.conf ]; then
	CONFDIR=/etc/athena; export CONFDIR
fi

. ${ROOT}${CONFDIR}/rc.conf
if [ -f ${CONFVARS} ]; then
	. ${CONFVARS}
fi

if [ "${PUBLIC}" = "true" ]; then
	NEWUNIX=true
	NEWBOOT=true
	FULLCOPY=true
	NEWMAILCF=true
	rm -f	${ROOT}/$HOME/.hushlogin \
		${ROOT}/hesiod.conf \
		${ROOT}/etc/*.local ${ROOT}/etc/athena/*.local \
		${ROOT}/${SITE}/usr/lib/*.local \
		${ROOT}/usr/vice/etc/CellServDB \
		${ROOT}/usr/vice/etc/CellServDB.public
	cp /dev/null ${ROOT}/etc/named.local
fi

if [ "${AFSCLIENT}" = "true" ]; then
	# Update CellServDB
	echo -n "Updating CellServDB.public..."
	if [ -s /afs/athena.mit.edu/service/CellServDB ]; then
		cp -p /afs/athena.mit.edu/service/CellServDB \
			${ROOT}/usr/vice/etc/CellServDB.public
	fi
	if [ ! -f ${ROOT}/usr/vice/etc/CellServDB ]; then
		rm -f ${ROOT}/usr/vice/etc/CellServDB
		ln -s CellServDB.public ${ROOT}/usr/vice/etc/CellServDB
	fi

	echo -n "aklog..."
	cp -p /srvd/bin/athena/aklog ${ROOT}/bin/athena/aklog

	echo -n "Fixing permissions on /usr/vice/cache..."
	chmod 700 ${ROOT}/usr/vice/cache/
	echo "done."
fi

# Verify /etc/athena/rc.conf has all the necessary variables
echo -n "Checking " ${CONFDIR}/"rc.conf..."
if [ "${PUBLIC}" = "true" ]; then
	sed -n	-e "s/^HOST=[^;]*/HOST=${HOST}/" \
		-e "s/^ADDR=[^;]*/ADDR=${ADDR}/" \
		-e "s/^MACHINE=[^;]*/MACHINE=${MACHINE}/" \
		-e "s/^NETDEV=[^;]*/NETDEV=${NETDEV}/" \
		-e p /srvd/etc/athena/rc.conf > ${ROOT}/${CONFDIR}/rc.conf
else
	conf="`cat /srvd/etc/athena/rc.conf|awk -F= '(NF>1){print $1}'`"
	vars=""
	for i in $conf; do
	   if [ `grep -c "^$i=" ${CONFDIR}/rc.conf` = 0 ]; then 
		vars="$vars $i"
	   fi
	done
	if [ "${vars}" != "" ]; then
	   echo "The following variables are being added:"
	   echo -n "	"
	   echo $vars
	   for i in $vars; do \
		grep "^$i=" /srvd/etc/athena/rc.conf >> ${ROOT}${CONFDIR}/rc.conf
	   done
	   echo "done."
	fi
fi

# We could be more intelligent and shutdown everything, but...
echo -n "Shutting down running services..."
if [ -f /var/run/inetd.pid ]; then
	kill `cat /etc/inetd.pid` > /dev/null 2>&1
fi
if [ -f /var/run/syslog.pid ]; then
	echo -n "syslogd..."
	kill `cat /var/run/syslog.pid` > /dev/null 2>&1
fi
if [ -f /etc/athena/snmpd.pid ]; then
	echo -n "snmpd..."
	kill `cat /etc/athena/snmpd.pid` > /dev/null 2>&1
fi
if [ -f /etc/athena/named.pid ]; then
	echo -n "named..."
	kill `cat /etc/athena/named.pid` > /dev/null 2>&1
fi
echo "done"

echo -n "Tracking changes..."
if [ "${FULLCOPY}" = "true" ]; then
	track -v -F /srvd -T ${ROOT}/ -d -W /srvd/usr/athena/lib
fi
echo "done."

echo -n "Updating version..."
echo -n "Athena Workstation ($MACH) Version $NEWVERS" >> ${ROOT}${CONFDIR}/version
date >> ${CONFDIR}/version
echo "done"

# Re-customize the workstation
if [ "${PUBLIC}" = "true" ]; then
	rm -rf /${SERVERDIR}
fi

if [ -d ${ROOT}/${SITE}/server ]; then
	echo "Running mkserv."
	echo "Restarting named."
	named
	$MKSERV -v update
fi

sync
exit 0

