#!/bin/sh
#
# Update script for Project Athena workstations
#
# $Id: update_ws.sh,v 1.36 1996/06/01 18:58:24 ghudson Exp $
#

trap "" 1 15

ROOT="${ROOT-}"; export ROOT
CONFDIR="${CONFDIR-/etc/athena}"; export CONFDIR
LIBDIR=/srvd/usr/athena/lib/update;	export LIBDIR
PATH=/bin:/srvd/bin:/srvd/sbin:/srvd/etc/athena:/srvd/bin/athena:/srvd/usr/athena/etc:/srvd/usr/bin:/srvd/usr/sbin:/usr/bin:$LIBDIR ; export PATH
ATHENA_SYS=`/bin/athena/machtype -S`
MKSERV=/afs/sipb.mit.edu/project/mkserv/arch/${ATHENA_SYS}/bin/mkserv
SERVERDIR=/var/server
OS=`uname -a | tr A-Z a-z`

if [ ! -d /srvd/bin ]; then
	exit 1
fi

if [ ! -f ${ROOT}/${CONFDIR}/version ]; then
	echo "Athena Update (???) Version 0.0A Mon Jan 1 00:00:00 EDT 0000" \
		> ${ROOT}/${CONFDIR}/version
fi

NEWVERS=`awk '{a=$5}; END{print a}' /srvd/.rvdinfo`
VERSION=`awk '{a=$5}; END{print a}' ${ROOT}/${CONFDIR}/version`
export NEWVERS VERSION

if [ -f ${ROOT}/${CONFDIR}/rc.conf ]; then
   . ${ROOT}/${CONFDIR}/rc.conf
else
   PUBLIC=true; export PUBLIC
   AUTOUPDATE=true; export AUTOUPDATE
fi

AUTO=false
if [ `expr $0 : '.*auto_update'` != "0" ]; then
	AUTO=true;
fi

case `echo $VERSION $NEWVERS | awk '(NR==1) { \
	if ($1 == "Update") {print "OOPS"} \
	else if ($1 >= $2) {print "OK"} \
	else if (substr($1,1,3) == substr($2,1,3)) {print "INCR"} \
	else {print "FULL"}}'` in
OOPS)
	if [ ! -f /var/tmp/update.check ]; then
		logger -t `hostname` -p user.notice at revision $VERSION
		cp /dev/null /var/tmp/update.check
	fi

	echo "This system is in the middle of an update.  Please contact SIPB"
	echo "at x3-7788 or send mail to ${os}-help@mit.edu.  Thank you."
	exit 1
	;;
OK)
	if [ "${AUTO}" != "true" ]; then
		echo "It appears you already have this update."
	fi
	exit 0
	;;
INCR|FULL)
	;;
esac

if [ "${PUBLIC}" = "true" ]; then
	AUTOUPDATE=true
fi

if [ "${AUTO}" = "true" -a "${AUTOUPDATE}" != "true" ]; then
	cat <<EOF

	A new version of SIPB-Athena software is now available.
	[XXX instructions]
EOF
	if [ ! -f /var/tmp/update.check ]; then
		logger -t `hostname` -p user.notice at revision $VERSION
		cp /dev/null /var/tmp/update.check
	fi

	case "$1" in
	reactivate|rc|"") ;;
	*) sleep 20 ;;
	esac

	exit 1
fi

if [ "`whoami`" != "root" ];  then
	echo "You are not root.  This update script must be run as root."
	exit 1
fi

if [ -d ${SERVERDIR} ] ; then
	if [ -s ${MKSERV} ]; then
		${MKSERV} updatetest
		if [ $? -ne 0 ]; then
			echo "Update cannot be performed as mkserv services cannot be found for all services"
			exit 1
		fi
	else
		echo "Update cannot be performed as mkserv binary not available"
	fi
fi

if [ ! -d ${ROOT}/.deleted ] ; then
	mkdir ${ROOT}/.deleted
fi

if [ "${AUTO}" = "true" -a "$1" = "reactivate" ]; then
	if [ -f /etc/athena/dm.pid ]; then
		kill -FPE `cat /var/run/dm.pid`
		ln ${ROOT}/etc/athena/dm ${ROOT}/.deleted/
	fi

	sleep 2
fi

FULLCOPY=true; export FULLCOPY

if [ "${AUTO}" = "true" ]; then
	cat <<EOF

THIS WORKSTATION IS ABOUT TO UNDERGO AN AUTOMATIC SOFTWARE UPDATE.
THIS PROCEDURE MAY TAKE SOME TIME.

PLEASE DO *NOT* DISTURB IT WHILE THIS IS IN PROGRESS.

EOF
	case "$1" in
	reactivate|activate|deactivate)
	        rm /tmp/pids
	        cat /etc/syslog.pid >/tmp/pids
	        cat /etc/inetd.pid >>/tmp/pids 2>/dev/null
		cat /var/run/inetd.pid >>/tmp/pids 2>/dev/null
	        cat /etc/athena/inetd.pid >>/tmp/pids 2>/dev/null
	        cat /etc/snmpd.pid >>/tmp/pids
	        cat /etc/athena/snmpd.pid >>/tmp/pids
	        cat /etc/athena/zhm.pid >>/tmp/pids
		(kill -TERM `cat /tmp/pids`) > /dev/null 2>&1
		;;
	esac

	sh $LIBDIR/do_update < /dev/null
	detach -h -n -q -a
	echo "Auto Update Done, System will reboot in 15 seconds."
	sync
	sleep 15
	exec reboot
else
	sh $LIBDIR/do_update
fi
echo "Done"
exit 0
