#include <stdio.h>
#include <X10/Xlib.h>
#define AUX 
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"

void
signal_unexpected(what,funcname,linecount)
 char *what, *funcname;
 int linecount;
{
printf("%s: Unexpected %s at line %d.\n",funcname,what,linecount);
exit(1);
}


void
signal_missing_data(what,funcname,linecount)
     char *what, *funcname;
     int linecount;
{
  printf("%s: Missing %s at line %d\n",funcname,what,linecount);
}



void
screen_error(s, part,lkup)
  Screen	*s;
  char 		*part;
  Lkup_union    *lkup;
{
  static char 	*funcname = "Screen_error";

  if(strlen(s->name)){
	  printf("%s: bad %s for screen %s\n",funcname,part,s->name);
	  printf("screen: %s, type %s, pos %d,%d, size %d,%d, parent %s, bdrwdth %d, border %d, bckgnd %d\n",
		   s->name,lkup->name, s->x,s->y,s->width,s->height,
		   s->parentname, s->borderwidth, s->border,s->background);
 	  exit(1);
   }
  else
  {
	  printf ("%s: bad %s for screen after %s\n",
		  funcname,part,s->prev->name);
	  printf("screen: %s, type %d, pos %d,%d, size %d,%d, parent %s, bdrwdth %d, border %d, bckgnd %d\n",
		   s->name,lkup->name, s->x,s->y,s->width,s->height,
		   s->parentname, s->borderwidth, s->border,s->background);
	  exit(1);
    }
}


char *index();

char *
parse(type,x,p1)
   int 		type;
   int 		*x;
   char		*p1;
{
   char		*p2, tmp[Nchars];
	if((p2 = index(p1,',')) != 0)
	{
	  	*p2 = '\0';
		if(type == Str)
		{ 
			strcpy((char *) tmp, p1);
			sscanf(tmp,"%s",x);
		
		 }
		else if(type == Num) *x = atoi(p1);
	  	p1 = ++p2;
	  	return p1;
	 }
        else
	{
		if((p2 = index(p1,')')) != 0)
		{
	  		*p2 = '\0';
			if(type == Str)
			{
				strcpy((char *) x, p1);
				sscanf(tmp,"%s",x);
			 }
			else if(type == Num) *x = atoi(p1);
	  		p1 = ++p2;
	  		return p1;
	 	 }

 		else return (char *) NULL;
	 }
}



char *
get_data_line(fp)
  FILE 		*fp;
{
  static char   *funcname = "get_data_line";
  static char 	line[Nchars];

	while( !feof(fp)){
  		++linecount;
  		fgets(line, Nchars, fp);
		switch(line[0]){
			case '#':
			case ' ':
			case '\t':
			case '\n':
				break;
			default:
				return(line);
		 }
	 }
	return (char *) NULL;
}




