
/* ev_exec.c */

#include <stdio.h>
#include "hash.h"
#include "clink.h"
#include <X10/Xlib.h>
#include "ev_tokens.h"

extern ENV_PTR	curenv;
extern OBJ_PTR	curobj;
extern CODE_PTR	curcode;

int	return_flag = 0;	/* leave current function code segment */
int	next_flag = 0;		/* skip to next iteration of repeat */
int	exit_flag = 0;		/* pop up until we leave initial handler */
int	exit_rpt_flag = 0;	/* pop up until we leave initial handler */

int	ev_discard = 0;		/* don't process any instructions */

#define ev_FlagsSet	(return_flag || next_flag || exit_flag || exit_rpt_flag)
#define ev_ClearFlags	(ev_discard = return_flag = next_flag = exit_flag = exit_rpt_flag = 0)

int
ev_ExecErr( msg )
	char *msg;
{
	printf(">> EventScript EXEC error: %s\n",msg);
	return -1;
}

int
ev_SendMsg( objname, msg )
	char *objname;
	char *msg;
{
CODE_PTR	cp = NULL;
int		ret = -1;
VAR_PTR		vp;
OBJ_PTR		op, temp;
char		handlerName[MAXSTR];
char		theParm[MAXSTR];
int		pcount = 0;
int		i;
char *		stpword();

	if( !curenv )
	{
		printf("ev_SendMsg: no current environment defined\n");
		return -1;	
	}

	if( ev_Debug )
		printf("RAW MESSAGE: <%s> to <%s>\n",msg,objname);

	msg = stpword( msg, handlerName, MAXSTR );
	if( ev_Debug )
		printf("handlerName: <%s>\n",handlerName);

	if( !objname || !strlen(objname) || !(op = findobj( curenv, objname )) )
	{
		if( !(cp = findcode(curenv->global_code,handlerName)) || 
			cp->type != MSG_CODESEG )
				printf("ev_SendMsg: message '%s' not handled\n",
					handlerName);
		return -1;
	}
	else if( !cp && (!(cp = findcode(op->codelist, handlerName)) || 
		cp->type != MSG_CODESEG) )
	{
		printf("ev_SendMsg: handler not found for message <%s>\n",handlerName);
		return -1;	
	}

	/* init the handler's parms */

	for( i=0; i<cp->nparms; i++ )
	{
		cp->parms[i]->type = T_string;
		cp->parms[i]->val.sval[0] = 0;
	}

	/* put the parms into the handler's codeseg */

	while( msg && strlen(msg) )
	{
		if( (pcount+1) > cp->nparms )
		{
			if( ev_Debug )
				printf("too many parms given to handler '%s'; ignored\n",
					handlerName);
			break;
		}
		msg = stpword(msg,theParm,MAXSTR);
		if( ev_Debug )
			printf("got Parm: <%s>\n",theParm);
		strcpy( cp->parms[pcount++]->val.sval, theParm );
	}

	temp = curobj;
	curobj = op;

	ret = ev_HandleMsg( cp );

	curobj = temp;

	if( ev_Debug )
	{
		printf("===>> VARS after:\n");
		for( vp=cp->varlist; vp; vp=vp->next )
			print_var( vp );
	}
	return ret;
}

int
ev_InitVars( cp )	/* initializes all non-static vars in the code seg */

	CODE_PTR	cp;
{
VAR_PTR	vp;

	if( !cp )
		return -1;

	for( vp = cp->varlist; vp; vp = vp->next )
	{
		/* init all non-static and non-parm vars to 0 */
		if( strlen(vp->name) && !vp->IsStatic && !vp->IsParm )
		{
			toNum(vp);
			vp->val.ival = 0;			
		}
	}
	return 0;
}

int
ev_HandleMsg( cp )
	CODE_PTR	cp;
{
CODE_PTR	temp;

	if( cp && cp->code[0] == T_begblock )
	{
		temp = curcode;
		curcode = cp;

		ev_InitVars(cp);		
		ev_ExecBlock(cp->code,0);
		ev_ClearFlags;	/* a macro; gets rid of exit, next, etc. flags */

		curcode = temp;
	}
	else
		return ev_ExecErr( "invalid code segment; not a block" );

	return 0;
}

int
ev_ExecBlock(theCode,theInstr)
	unsigned long *	theCode;
	int		theInstr;
{
int	do_else = 0;
int	logic = 0;

	/* returns -1 on error, or else index of next instruction after the block */

	EV_DEBUG(3,(">> entering ExecBlock\n"));
	
	if( ev_discard )
		return ev_SkipBlock( theCode, theInstr );
	
	++theInstr;		/* go over the '{' */
	
	while( theCode[theInstr] != T_endblock )
	{
		EV_DEBUG(3,(">> %s instr ",(ev_discard?"discarding":"looking at")));
		EV_DEBUG(3,(" %s\n",PrintInstr(theCode[theInstr])));

		if( ev_discard )
		{
			if( theCode[theInstr] == T_begblock )
				theInstr = ev_SkipBlock(theCode,theInstr);
			else
				++theInstr;
		}
		else switch( theCode[theInstr] )
		{
		case T_if:
			theInstr = ev_ExecIf(theCode,theInstr,&logic);
			if( !logic )
				do_else = 1;
			else
				do_else = 0;
			if( ev_FlagsSet )
				ev_discard = 1;
			break;
		case T_else:
			if( !do_else )
				theInstr = ev_SkipElses(theCode,theInstr);
			else
			{
				++theInstr;
				if( theCode[theInstr] == T_if )
				{
					theInstr = ev_ExecIf(theCode,theInstr,&logic);
					if( !logic )
						do_else = 1;
					else
						do_else = 0;
					if( ev_FlagsSet )
						ev_discard = 1;
				}
				else if( theCode[theInstr] == T_begblock )
					theInstr = ev_ExecBlock(theCode,theInstr);
				else 
				{
					printf("ev_ExecBlock(): ERROR: bad if-else exec form; %d\n",
						theCode[theInstr]);
				}
			}
			break;
		case T_repeat:
			theInstr = ev_ExecRepeat(theCode,theInstr);
			do_else = 0;
			if( ev_FlagsSet )
				ev_discard = 1;
			break;
		default:
			theInstr = ev_ExecCommand(theCode,theInstr);
			do_else = 0;
			if( ev_FlagsSet )
				ev_discard = 1;
			break;
		}
	}

	++theInstr;		/* go over the '}' */
	
	return theInstr;
}

int
ev_SkipElses(theCode,theInstr)
	unsigned long *	theCode;
	int		theInstr;
{
	/* comes in sitting on the 'else' */
	
	while( theCode[theInstr] == T_else )
	{
		while( theCode[theInstr] != T_begblock )
			++theInstr;
		theInstr = ev_SkipBlock(theCode,theInstr);
	}
	return theInstr;
}

int
ev_SkipBlock(theCode,theInstr)
	unsigned long *	theCode;
	int		theInstr;
{
	do
	{
		++theInstr;
		if( theCode[theInstr] == T_begblock )
			theInstr = ev_SkipBlock(theCode,theInstr);
	} while( theCode[theInstr] != T_endblock );
	++theInstr;	/* go over the '}' */ 
	return theInstr;
}

int
ev_ExecIf(theCode,theInstr,theLogic)
	unsigned long *	theCode;
	int		theInstr;
	int *		theLogic;
{
VAR	v;
VAR_PTR vp;
int *	ip;

	initvar(&v);
	
	EV_DEBUG(3,(">> entering ExecIf; instr is "));
	EV_DEBUG(3,(" %s\n",PrintInstr(theCode[theInstr])));
	
	++theInstr;		/* go over the 'if' */
	
	ip = (int *) theCode[theInstr];
	if( ip && *ip == EXPR_MAGIC )
	{
		ev_EvalExpr((EXPR_PTR) theCode[theInstr], &v);
		vp = &v;
	}
	else 
		return ev_ExecErr( "<if> not followed by expression" );
			
	++theInstr;		/* go over the expression */

	if( (*theLogic = IsTrue(vp)) )
		theInstr = ev_ExecBlock(theCode,theInstr);
	else		/* don't do it */
		theInstr = ev_SkipBlock(theCode,theInstr);

	return theInstr;
}

int
ev_ExecRepeat(theCode,theInstr)
	unsigned long *	theCode;
	int		theInstr;
{
int top = 0;
int repeat = 0;
int *ip;
VAR_PTR vp;
VAR v;
int logic;

	initvar(&v);

	EV_DEBUG(3,(">> entering ExecRepeat\n"));
	theInstr++;		/* go over repeat */
	
	if( theCode[theInstr] == T_begblock )	/* test at bottom */
	{
		top = theInstr;	/* set top of repeat block */
		do
		{
			theInstr = top;
			theInstr = ev_ExecBlock(theCode,theInstr);
			if( theCode[theInstr] == T_while )
				logic = 1;
			else
				logic = 0;	/* for until, execute if false */
			++theInstr;		/* go over the while or until */
			ip = (int *) theCode[theInstr];
			if( ip && *ip == EXPR_MAGIC )
			{
				ev_EvalExpr((EXPR_PTR) theCode[theInstr], &v);
				vp = &v;
			}
			else if( ip && *ip == VAR_MAGIC )
				vp = (VAR_PTR) theCode[theInstr];
			++theInstr;	/* go over the expr */
			++theInstr; /* go over the ';' */
			if( IsTrue(vp) == logic )
				repeat = 1;
			else
				repeat = 0;
			if( next_flag )
			{
				next_flag = 0;
				ev_discard = 0;
			}
		} while( repeat && !ev_discard );
	}
	else	/* test at top */
	{
		if( theCode[theInstr] == T_while )
			logic = 1;
		else
			logic = 0;	/* for until, execute if false */
		++theInstr;		/* go over the while or until */
		top = theInstr; /* set top of the repeat block */
		repeat = 1;
		
		while( repeat && !ev_discard )
		{
			theInstr = top;
			ip = (int *) theCode[theInstr];
			if( ip && *ip == EXPR_MAGIC )
			{
				ev_EvalExpr((EXPR_PTR) theCode[theInstr], &v);
				vp = &v;
			}
			else if( ip && *ip == VAR_MAGIC )
				vp = (VAR_PTR) theCode[theInstr];
			++theInstr;		/* go over the expr */
	
			if( IsTrue(vp) == logic )
				theInstr = ev_ExecBlock(theCode,theInstr);
			else
			{
				theInstr = ev_SkipBlock(theCode,theInstr);
				repeat = 0;
			}
			if( next_flag )
			{
				next_flag = 0;
				ev_discard = 0;
			}
		}
	}
	if( exit_rpt_flag )
	{
		exit_rpt_flag = 0;
		ev_discard = 0;
	}
	return theInstr;
}

int
ev_ExecCommand(theCode,theInstr)
	unsigned long *	theCode;
	int		theInstr;
{
VAR_PTR	vp;
VAR	v;
VAR_PTR	res;
int *ip = NULL;

	initvar(&v);

	EV_DEBUG(3,(">> in ExecCommand, instr is "));
	EV_DEBUG(3,(" %s\n",PrintInstr(theCode[theInstr])));
	
	switch( theCode[theInstr] )
	{
	case T_put:
		++theInstr;	/* go over put */
		ip = (int *) theCode[theInstr];
		if( ip && *ip == VAR_MAGIC )
			vp = (VAR_PTR) theCode[theInstr];
		else if( ip && *ip == EXPR_MAGIC )
		{
			ev_EvalExpr( (EXPR_PTR) theCode[theInstr], &v );
			vp = &v;
		}
		else if( ip && *ip == FCALL_MAGIC )
		{
			ev_EvalFunc((FCALL_PTR) theCode[theInstr], &v);
			vp = &v;
		}

		++theInstr;	/* go over expr */
		++theInstr;	/* go over the into */
		res = (VAR_PTR) theCode[theInstr]; /* get var */
		++theInstr;	/* go over the var */
		++theInstr;	/* go over the ';' */

		ev_CopyVal( vp, res );
			
		EV_DEBUG(3,(">> final result of put: "));
		EV_DEBUG(3,(" %s\n",print_var(res)));
		
		break;
	case T_return:
		if( curcode->type != FUNC_CODESEG )
			return ev_ExecErr( "attempted return outside of function" );
		++theInstr;	/* go over return */
		ip = (int *) theCode[theInstr];
		if( ip && *ip == VAR_MAGIC )
			vp = (VAR_PTR) theCode[theInstr];
		else if( ip && *ip == EXPR_MAGIC )
		{
			ev_EvalExpr( (EXPR_PTR) theCode[theInstr], &v );
			vp = &v;
		}
		else if( ip && *ip == FCALL_MAGIC )
		{
			ev_EvalFunc((FCALL_PTR) theCode[theInstr], &v);
			vp = &v;
		}

		++theInstr;	/* go over ptr */
		++theInstr;	/* go over ';' */

		ev_CopyVal( vp, &curcode->returned );

		EV_DEBUG(4,(">> final result of return: "));
		EV_DEBUG(4,(" %s\n",print_var(&curcode->returned)));

		return_flag = 1;
		break;
	case T_exit:
		++theInstr;	/* go over exit */
		if( theCode[theInstr] == T_repeat )
			exit_rpt_flag = 1;
		else
			exit_flag = 1;
		++theInstr;	/* go over var or repeat */
		++theInstr;	/* go over ';' */
		exit_flag = 1;
		break;
	case T_next:
		++theInstr;	/* go over next */
		++theInstr;	/* go over repeat */
		++theInstr;	/* go over ';' */
		next_flag = 1;
		break;
	case T_send:
		++theInstr;	/* go over send */
		vp = (VAR_PTR) theCode[theInstr];
		ev_GetCval( vp );
		++theInstr;	/* go over var */
		++theInstr;	/* go over to */
		res = (VAR_PTR) theCode[theInstr];
		ev_GetCval( vp );
		++theInstr;	/* go over other var */
		++theInstr;	/* go over ';' */
		toStr(vp);
		toStr(res);
		ev_SendMsg( res->val.sval, vp->val.sval );
		break;
	default:
		ip = (int *) theCode[theInstr];
		if( ip && *ip == FCALL_MAGIC )
		{
			ev_EvalFunc((FCALL_PTR) theCode[theInstr], &v);
			vp = &v;

			EV_DEBUG(4,(">> final result of function: "));
			EV_DEBUG(4,(" %s\n",print_var(&curcode->returned)));

			++theInstr;	/* go over the fcall */
			++theInstr;	/* go over the ';' */
		}
		else
		{
			printf("<ERROR: discarding command #%d: %ld!!>\n",theInstr,theCode[theInstr]);
			while( theCode[theInstr] != T_cmdend )
				++theInstr;
			printf("finished discarding at instr #%d\n",theInstr); 
			++theInstr;
		}
		break;
	}
	return theInstr;
}

