#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#include "defs.h"

extern Screen *screen_sets[Screen_sets];
extern make_tk_widget();

#define MATCH 0

resolve_names()
{
  char 		*funcname = "resolve_names";
  Screen 	*s;
  Screenlist    *sl;
  Element 	*ele, *tele;
  Package 	*pck, *tpck;
  Map		*m;
  DimRep        *rep;
  int 		i,c;


/*
*  Resolve Names
*
*  The routine goes through the list of packages and resolves the
*  names referenced by that package.  First it finds the packages in
*  the `unext' slot.  It creates closed loops of packages with home
*  packages flagged.
* 
*  Then it finds the window set listed in `screen_name'.
*  The windows have already been created by Makewindows() before coming
*  here.
*
*  Once it has the set of windows to work from, it starts down
*  the list of elements in the package.
*  For each element, it resolves the `next' name and finds the display
*  window for that element in the list of windows held by the parent
*  package.
*
*  If the element is a widget of some sort, then it goes down the list
*  of mappings to actually build the widgets and get the window pointers
*  for them.  Coming in, the data for the widget is held in the
*  `map->simple.w' slot, as a pointer to a struct of the appropriate type.
*/

	pck = first_package;

	while(pck != 0)
	{
Debug((stderr," starting on package `%s'\n",pck->name));

	        for(i = 0; i < MaxDims && pck->dimension[i]; ++i)
	        {
		        pck->position[i] = pck->dimension[i]->initial;
	         }

  		if(strlen(pck->nextname))
		{
    		    tpck = first_package;
    		    while(strcmp(pck->nextname, tpck->name) != MATCH)
      		    {
			  if((tpck = tpck->next) == 0)
	  		  {
	    		    printf("%s: can't match next: %s in package %s\n"
		   		,funcname, pck->nextname, pck->name);
	    		    exit(1);
	  		   }
      	 	     }
    		    pck->unext = tpck;
		    pck->unext->uprev = pck;
  		 }
		else				/* close loop */
		{
			for(tpck = pck; tpck->uprev; tpck = tpck->uprev);
			tpck->uprev = pck;
			pck->unext = tpck;
		 }
 

		if(strlen(pck->screen_name))
		{
  		   	for(i=0; i < Screen_sets; ++i)
			{
      				if(strcmp(pck->screen_name, 
					screen_sets[i]->name) == MATCH)
				{
      					break;
    				 }
			 }

			if(i < Screen_sets)
			{
  				pck->window = screen_sets[i];
			 }
    			else
			{
      		          	printf("%s: can't match screen named %s in package %s\n",funcname, pck->screen_name, pck->name);
      			  	exit(1);
    			 }
   			 
		 }
		else
		{
  			printf("%s: missing screen name in package %s\n"
				,funcname,pck->name);
  			exit(1);
		 }

/*
*  Take care of the representations.
*/
		rep = pck->reps;
		while( rep != 0 )
		{
    		    	tpck = first_package;
    		    	while(strcmp(rep->packname, tpck->name) != MATCH)
      		    	{
			  	if((tpck = tpck->next) == 0)
	  		  	{
	    		     		printf("%s: can't match package `%s'\n"
		   		    	    ,funcname, rep->packname );
	    		    		exit(1);
	  		   	 }
      	 	     	 }
		    	rep->p = tpck;
			for(i = 0; i < tpck->ndims; ++i)
			{
      				if(strcmp(rep->dimname,
					tpck->dimension[i]->name) == MATCH)
				{
      					break;
    				 }
			 }

			if(i < tpck->ndims)
			{
				rep->d = tpck->dimension[i];
				c = rep->d->initial;
				if(!rep->extent) 
				    rep->extent = rep->d->max - rep->d->min;
			        rep->low = (c/rep->extent)*rep->extent;
				rep->high = rep->low + rep->extent;
				if(rep->high > rep->d->max)
				{
				    rep->high = rep->d->max;
				    rep->low = rep->high - rep->extent;
	 			 }
				rep->next = tpck->dimension[i]->rep;
				tpck->dimension[i]->rep = rep;
			 }
    			else
			{
      		          	printf("%s: can't match dimension `%s'\n"
				    ,funcname, rep->dimname);
      			  	exit(1);
    			 }

			rep = rep->tmp;
		 }

/*
*   For each element in the current package, check to see if it's a 
*   widget type.  If so, create the widget(s).  Then, for all elements,
*   find out what window they're supposed to be mapped into.
*/
		ele = pck->element;
Debug((stderr,"  elements...\n"));
		while(ele != 0)
		{
Debug((stderr,"   `%s'..",ele->name));
	        	sl = ele->screen;
			while(sl)
			{				
				s = pck->window;
				while(strcmp(sl->name, s->name) != MATCH)
			        {
					if((s = s->next) == 0)
					{
					      printf("%s: can't match screen: %s in element %s\n"
					           ,funcname, sl->name
						   , ele->name);
					      exit(1);
					  }
				  }
				sl->s = s;
				sl = sl->next;
			 }
Debug((stderr,"screens ok..\n"));
			if(ele->type == TK_WIDGET)
			{
				m = ele->map;
				while(m != 0)
				{
				        if(m->simple.type > Unused_map)
					{

Debug((stderr,"   widget, type %d, ele `%s'...",m->simple.type,ele->name));

					    make_tk_widget(ele, m);
Debug((stderr,"done\n"));
					    m = m->simple.next;
					 }
					else free((char *)m); 
				 }
			 }
Debug((stderr,"widgets done.."));
			if( ele->type == TEXT)
			{
Debug((stderr,"\n    text, ele `%s'...",funcname,m->simple.type,ele->name));
				m = ele->map;
				make_tk_widget(ele,m);
			 }
			ele = ele->next;    
  
  		}
Debug((stderr,"\n finished resolving package `%s'\n",pck->name));
	pck = pck->next;
	 
	}

}




Window
findparent(i, name, child)
 int i;  /* i is where to begin in the screen chain */
 char *name, *child;
{
  char *funcname = "findparent";
  Screen *s;
  
  s = screen_sets[i];
  while (s != 0){
    	if(strcmp(name, s->name))
    	{
      		s = s->next;
    	 }
    	else
	{
      		if (s->w) 
		{
			return(s->w);
		 }
      		else
		{
            		printf("%s: can't create child %s before parent %s\n",
		     	    funcname,child,name);
	    		exit(1);
	  	 }
    	 }
   }
 
  printf("%s: can't find window named %s in this set.\n",funcname,name);
  exit(1);    
}



int
makewindows()
{
char *funcname = "makewindows";
Screen *s;
Window parent;
OpaqueFrame frame;
int i, x;

for(i=0;(s = screen_sets[i]);++i)
{
  while(s != 0)
  {
    s->parent = strcmp(s->parentname, "RootWindow") ? 
      (Window) findparent(i,s->parentname,s->name) : RootWindow;
    switch(s->type)
    {


    case WINDOW:
      s->w = XCreateWindow(
		    s->parent,
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );


      if (s->w == 0) {
	printf("%s: can't open opaque window\n", funcname);
	exit(1);
      }
      break;

    case TRANSPARENCY:
      printf("making transparent window named %s\n",s->name);

      s->w = XCreateTransparency(
			   s->parent,
			   s->x,
			   s->y,
			   s->width,
			   s->height  );

        if (s->w == 0) {
	  printf("%s: can't open transparent window\n", funcname);
	  exit(1);
	}

       break;

    case VIDEO:


      s->w = XCreateVideoWindow (
		    s->parent,
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }
printf("made video window named %s,  id `%d'\n",s->name, s->w);

/*        XMapWindow(s->w);
        XStartVideo(s->w,0,0,PRIO_2);
*/
        break;

    case STILL:
printf("making still video named %s\n",s->name);

      s->w = XCreateVideoWindow (
		    s->parent,
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }

      break;
    default:
      break;
  }

  s = s->next;
  }
}

}
