
#include <stdio.h>
extern char *malloc(), *calloc(), *realloc();

#define MemId long

/*
 * MemAssoc - Association elements used in the MemAssocTable data structure.
 * MemAssoc's are used as bucket entries in the association table.
 */

typedef struct _Mem_assoc {
    struct _Mem_assoc *next;	/* Next object in this bucket. */
    struct _Mem_assoc *prev;	/* Previous obejct in this bucket. */
    MemId Mem_id;		/* Pointer to valid object in disk/core */
    MemId data;			/* Pointer to duplicate object in other core/disk memory. */
} MemAssoc;

/* 
 * MemAssocTable - Mem_id to data structure pointer association
 * table.  A MemAssocTable is a hash table who's buckets are circular
 * queue's of MemAssoc's.  The MemAssocTable is constructed from an array of
 * MemAssoc's which are the circular queue headers (bucket headers).  
 * A MemAssocTable consists an MemAssoc pointer that points to the first
 * bucket in the bucket array and an integer that indicates the number
 * of buckets in the array.
 */

typedef struct _Mem_assoc_table {
    struct _Mem_assoc *buckets;	/* Pointer to first bucket in bucket array.*/
    int size;			/* Table size (number of buckets). */
} MemAssocTable;

/*
 * Declare the MemAssocTable routines that don't return int.
 */

MemId 		MemLookUpAssoc();
MemAssocTable *	MemCreateAssocTable();
