#include <stdio.h>
#include "ev_tokens.h"
#include "Xtlib.h"
#include "MenuMgr.h"

#define SCOPE extern
#include "XVideo.h"

#include "diskmem.h"	/* the new thing */

extern int ev_Debug;

extern ENV_PTR	curenv;

main(argc,argv)
	int	argc;
	char *argv[];
{
char fn[64];
FILE *fp;
char msg[64];
char objname[64];
CODE_PTR	cp;
int	ev_Kbd = 0;
HashTablePtr	C_ht;
static char *dmfile = "xs.dm";


	if( argc > 1 )
		strcpy(fn,argv[1]);

	if( argc > 2 )
	{
		if( sscanf(argv[2],"-d%d",&ev_Debug) != 1 )
			ev_Debug = 0;
		else
			printf("setting debug level to %d\n",ev_Debug);
	}
	if( argc > 3 )
	{
		if( !strcmp(argv[3],"-k") )	/* allow keyboard input */
			ev_Kbd = 1;
		else
			ev_Kbd = 0;
	}

	ev_MakeCBinding(argv[0]);

	printf("Performing Initializations ...\n");

	XOpenDisplay();
	XtInitialize();
	InitErrorHandler();
	mm_InitMenus( "xs" );
	InitColors();
	XSetVideoDisplay();
	if( dm_Init( dmfile, argv[0] ) )	/* name of kernel file */
		exit(1);

	printf("... finished with Initializations.\n");

	printf("Retrieving kernel from disk file '%s' ...\n",dmfile);

	/* now, get everything back */

	dm_GetEveryThing();
	dm_CleanUp();

	printf("... finished retrieving kernel.\n");

	curenv = envlist;

	if( strlen(fn) && (fp = fopen(fn,"r")) != NULL )
	{
	/*	ev_MakeCBinding(argv[0]); */
		ev_SetFile(fp);
		ev_Parse();
		printf("successful parse\n");
		fclose(fp);
	}
	else if( strlen(fn) )
		printf("unable to open source file '%s'\n",fn);

	cp = findcode( curenv->global_code, "OpenEnv" );
	if( cp && cp->type == MSG_CODESEG )
		ev_HandleMsg( cp );
	else
		printf("couldn't find global handler 'OpenEnv'\n");

	while(1)
	{
		if( !ev_Kbd ) while(1)
		{
		XEvent	ev;
			XNextEvent(&ev);
			mm_HandleEvent(&ev);	/* needs to get it first */
			(void) XtDispatchEvent(&ev);
			handle_text(&ev);
			handle_msgs( &ev );
		}
		printf("message? ");
		gets(msg);
		if( !strcmp(msg,"quit") )
			break;
		else if( !strcmp(msg,"do X") )
		{
			while(1)
			{
			XEvent	ev;
				XNextEvent(&ev);
				mm_HandleEvent(&ev); /* needs to get it first */
				(void) XtDispatchEvent(&ev);
				handle_text(&ev);
				handle_msgs( &ev );
			}
		}
		printf("object? ");
		gets(objname);
		ev_SendMsg( objname, msg );
	}

}
