extern int linecount;


static int
getdisplay( fp, d )

	FILE *		fp;
	DisplayPtr	d;
{
static char *funcname = "Getdisplay";
int got_name = NO;
int n;
char *colon;
char line[MAXSTR],tname[MAXSTR],tval[MAXSTR];
char *rindex();


while( !feof(fp)){

  ++linecount;
  fgets( line, MAXSTR, fp );
  line[strlen(line) - 1] = NULL;
  if( line[0] == '#' || line[0] == ' ' || line[0] == '\t' 
     || !strlen(line) ){ 
       continue;
     }

  sscanf(line,"%s %s\n",tname,tval);
  if( (colon = rindex(tname,':')) !=0 ){
    *colon = '\0';
  }

  if((n=lookup(tname)) != NULL){
    switch(n){
    case DISPLAY:
    case INCLUDE:
    case DSP_ELEMENT:
    case SCR_ELEMENT:
    case MAP:
    case DIMENSION:
      if(got_name == NO)
	{
	  printf("Getdisplay: Name missing in display above line %d\n"
		 ,linecount);
	}
      else
	{
	  printf("display: %s, next %s, active %d\n",
		 d->name,d->nextname, d->init_active);
	}
      return(n);
      break;
    case NAME:
      strcpy(d->name, tval);
      got_name = YES;
      break;
    case NEXT:
      strcpy(d->nextname,tval);  /* resolve to ptr later */
      break;
    case ACTIVE:
      d->init_active = YES;      
      if( (strlen(tval)) && (d->init_active = lookupval(tval))==NULL){
        printf("%s: Bad display->active in line %d\n",funcname,linecount);
      }
      break;
    default:
      printf("Getdisplay: can't use `%s', line %d\n",tname,linecount);
    }
  tval[0] = NULL;
  }
   
 }   
      printf("display: %s, next %s, type %d, active %d\n",
	     d->name,d->nextname, d->init_active);


}





static int
getelement( fp, e )

	FILE *		fp;
	ElementPtr	e;
{
static char *funcname = "Getelement";
int got_name = NO;
int got_type = NO;
int n, compound = NO;
char *colon;
char line[MAXSTR],tname[MAXSTR],tval[MAXSTR];
char *rindex();


while( !feof(fp)){

  ++linecount;
  fgets( line, MAXSTR, fp );
  line[strlen(line) - 1] = NULL;
  if( line[0] == '#' || line[0] == ' ' || line[0] == '\t' 
     || !strlen(line) ){ 
       continue;
     }

  sscanf(line,"%s %s\n",tname,tval);
  if( (colon = rindex(tname,':')) !=0 ){
    *colon = '\0';
  }

  if((n=lookup(tname)) != NULL){
    switch(n){
    case DISPLAY:
    case INCLUDE:
    case DSP_ELEMENT:
    case SCR_ELEMENT:
    case MAP:
    case DIMENSION:
      if(got_name == NO || got_type == NO)
	{
	  printf("Getelement: Name or type missing in element above line %d\n"
		 ,linecount);
	}
      else
	{
	  printf("element: %s, next %s, type %d, active %d\n",
		 e->name,e->nextname,e->type, e->init_active);
	}
      return(n);
      break;
    case NAME:
      strcpy(e->name, tval);
      got_name = YES;
      break;
    case NEXT:
      strcpy(e->nextname,tval);  /* resolve to ptr later */
      break;
    case TYPE:
      if((e->type = lookupval(tval)) == NULL){
        printf("%s: Bad element type in line %d\n",funcname,linecount);
      }
      got_type = YES;
      break;
    case ACTIVE:
      e->init_active = YES;      
      if( (strlen(tval)) && (e->init_active = lookupval(tval))== NULL){
        printf("%s: Bad element->active in line %d\n",funcname,linecount);
      }
      break;
    case FILENAME:
      strcpy(e->file, tval);
      compound = YES;
      break;
    case IN_POINT:
      e->map->in = atoi(tval);
      break;
    case OUT_POINT:
      e->map->out = atoi(tval);
      break;
    case ICON:
      e->map->icon = atoi(tval);
      break;
    case LABEL:
      strcpy(e->map->text, tval);
      got_name = YES;
      break;

    default:
      printf("Get_element: can't use `%s', line %d\n",tname,linecount);
    }
  }
   
 }   

      printf("element: %s, next %s, type %d, active %d\n",
	     e->name,e->nextname,e->type, e->init_active);

}


static int
getscreen( fp, s )

	FILE *		fp;
	ScreenPtr	s;
{
static char *funcname = "Getscreen";
int got_name = NO;
int n;
char *colon;
char line[MAXSTR],tname[MAXSTR],tval[MAXSTR];
char *rindex();


while( !feof(fp)){

  ++linecount;
  fgets( line, MAXSTR, fp );
  line[strlen(line) - 1] = NULL;
  if( line[0] == '#' || line[0] == ' ' || line[0] == '\t' 
     || !strlen(line) ){ 
       continue;
     }

  sscanf(line,"%s %s\n",tname,tval);
  if( (colon = rindex(tname,':')) !=0 ){
    *colon = '\0';
  }

  if((n=lookup(tname)) != NULL){
    switch(n){
    case DISPLAY:
    case DSP_ELEMENT:
    case SCR_ELEMENT:
    case MAP:
    case DIMENSION:
    case INCLUDE:
      if(got_name == NO)
	{
	  printf("Getscreen: Name missing in screen above line %d\n"
		 ,linecount);
	}
      else
	{
	  printf("screen: %s, next %s, type %d\n",
		 s->name,s->nextname,s->type);
	}
      return(n);
      break;
    case NAME:
      strcpy(s->name, tval);
      got_name = YES;
      break;
    case NEXT:
      strcpy(s->nextname,tval);  /* resolve to ptr later */
      break;
    case TYPE:
      if((s->type = lookupval(tval)) == NULL){
        printf("%s: Bad screen type in line %d\n",funcname,linecount);
      }
      break;
    default:
      printf("Getscreen: can't use `%s', line %d\n",tname,linecount);
    }
  }
 }   
      printf("screen: %s, next %s, type %d\n",
	     s->name,s->nextname,s->type);
   


}



static int
getmap( fp, m )

	FILE *		fp;
	MapPtr	m;
{
static char *funcname = "Getmap";
int got_name = NO;
int n;
char *colon;
char line[MAXSTR],tname[MAXSTR],tval[MAXSTR];
char *rindex();


while( !feof(fp)){

  ++linecount;
  fgets( line, MAXSTR, fp );
  line[strlen(line) - 1] = NULL;
  if( line[0] == '#' || line[0] == ' ' || line[0] == '\t' 
     || !strlen(line) ){ 
       continue;
     }

  sscanf(line,"%s %s\n",tname,tval);
  if( (colon = rindex(tname,':')) !=0 ){
    *colon = '\0';
  }

  if((n=lookup(tname)) != NULL){
    switch(n){
    case DISPLAY:
    case DSP_ELEMENT:
    case SCR_ELEMENT:
    case MAP:
    case DIMENSION:
    case INCLUDE:
      printf("map: in %d, out %d, icon %d, text %s\n",
	     m->in,m->out,m->icon,m->text);
      return(n);
      break;
    case IN_POINT:
      m->in = atoi(tval);
      break;
    case OUT_POINT:
      m->out = atoi(tval);
      break;
    case ICON:
      m->icon = atoi(tval);
      break;
    case LABEL:
      strcpy(m->text, tval);
      break;
    default:
      printf("Getmap: can't use `%s', line %d\n",tname,linecount);
    }
  }
 }   
	  printf("map: in %d, out %d, icon %d, text %s\n",
		 m->in,m->out,m->icon,m->text);
   


}



static int
getdimension( fp, d )

	FILE *		fp;
	DimensionPtr	d;
{
static char *funcname = "Getdimension";
int got_name = NO;
int n;
char *colon;
char line[MAXSTR],tname[MAXSTR],tval[MAXSTR];
char *rindex();


while( !feof(fp)){

  ++linecount;
  fgets( line, MAXSTR, fp );
  line[strlen(line) - 1] = NULL;
  if( line[0] == '#' || line[0] == ' ' || line[0] == '\t' 
     || !strlen(line) ){ 
       continue;
     }

  sscanf(line,"%s %s\n",tname,tval);
  if( (colon = rindex(tname,':')) !=0 ){
    *colon = '\0';
  }

  if((n=lookup(tname)) != NULL){
    switch(n){
    case DISPLAY:
    case DSP_ELEMENT:
    case SCR_ELEMENT:
    case MAP:
    case DIMENSION:
    case INCLUDE:
      if(got_name == NO)
	{
	  printf("Getdimension: Name missing in dimension above line %d\n"
		 ,linecount);
	}
      else
	{
	  printf("dimension: %s max %d, min %d, range %d, boundary %d\n",
		 d->name,d->max, d->min, d->range, d->boundary);
	}
      return(n);
      break;
    case NAME:
      strcpy(d->name, tval);
      got_name = YES;
      break;
    case MAX:
      d->max = atoi(tval);
      break;
    case MIN:
      d->min = atoi(tval);
      break;
    case RANGE:
      d->range = atoi(tval);
      break;
    case BOUNDARY:
      d->boundary = lookupval(tval);
      break;
    default:
      printf("Getdimension: can't use `%s', line %d\n",tname,linecount);
    }
  }
 }

printf("dimension: %s max %d, min %d, range %d, boundary %d\n",
       d->name,d->max, d->min, d->range, d->boundary);



}


