
#include <X/Xlib.h>
#include <stdio.h>

#define SCOPE extern
#include "XVideo.h"

static OpaqueFrame	frame;

main()

{
Window	mapwindow, v1, v2;
char	geom[32];
int	i;
int	x,y;
char	msg[32];

	XOpenDisplay(NULL);

	if( XSetVideoDisplay() ) printf("We are on a Parallax.\n");
	else printf("We are NOT on a Parallax.\n");

	frame.bdrwidth = 3;   /* was 16 */
	frame.border = XMakeTile(BlackPixel);
	frame.background = XMakeTile(BlackPixel);

	sprintf(geom,"%dx%d+0+0", VIDEO_WIDTH,VIDEO_HEIGHT );

	mapwindow = XCreateVideo (
	"Live Video",
		"tvid",
		NULL,
		geom,
		&frame,
		64,48);
	if ( !mapwindow ) {
		fprintf(stderr,"can't open live video window\n");
		exit(1);
		}

	XMapWindow(mapwindow);
	XSync(0);
	printf("here is a video window after creation, before display ...\n");
	sleep(3);

	VLABEL("Live Video - from XCreateVideo");
	XStartVideo( mapwindow, 0,0, 1 );
	XSync(0);
	printf("live video is now happening ...\n");
	sleep(3);

	XUnmapWindow(mapwindow);
	XSync(0);
	sleep(1);

	v1 = XCreateWindow( RootWindow, 100,100, 700,600, 4,	
		BlackPixmap,BlackPixmap );

	v2 = XCreateVideoWindow( v1, 50,50, 640,482, 2, 
		WhitePixmap,BlackPixmap );

	XMapWindow(v1);
	XSync(0);
	printf("this is parent window, normal black background ...\n");
	sleep(3);

	XMapSubwindows(v1);	/* test if v2 is indeed descendant */
	XSync(0);
	printf("child video window now plotted, also in black ...\n");
	sleep(3);

	VLABEL("Live Video - from XCreateVideoWindow");
	XStartVideo( v2, 0,0, 1 );
	XSync(0);
	printf("and now we have moving video in the child ...\n");
	sleep(3);
	
	XUnmapWindow(v2);
	XMapWindow(v2);
	XSync(0);
	printf("and now the video has stopped, and background is back ...\n");
	sleep(2);

	for( i=0; i<5; i++ ) {
		sprintf(msg,"Still Frame #%d",i+1);
		printf("%s\n",msg);
		VLABEL(msg);
		XStillVideo(v2,0,0,0,0,VIDEO_WIDTH,VIDEO_HEIGHT);
		sleep(1);
		}

	XUnmapWindow(v2);
	XMapWindow(v2);

	for( y=0; y<3; y++ )
		for( x=0; x<3; x++ ) {
			sprintf(msg,"%d,%d",x,y);
			VLABEL(msg);
			XScaleVideo(v2,0,0,VIDEO_WIDTH,VIDEO_HEIGHT,
				x*96 + x*16, y*72 + y*16,
				96,72 );
			XSync(0);
			printf("Scaled image %d,%d\n",x,y);
			sleep(1);
			}

	XSync(0);
	sleep(3);
	
}
