/*	timers.c	Matt Hodges, 10/87		*/

#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"

#define MT 10

static Dimension	*dim[MT];
static int		*flag[MT];
static int 		time[MT] = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
static int		interval[MT];
static int		ntimers, cur_time, cur;
static int		same[MT] = {-1};
static int		set_bit[] = { 1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
static int		same_mask = 0;



/*-------------------------------------*/
update_timers()
{
  static char		*func = "update_timer";
  struct itimerval  	value, ovalue;
  int			next, next_time;
  int			msec, i, j = 0;


	

	/*  Following is the now-synchronous routine called when time 
	*   is up.  Used to be asynch, but X calls from interrupt can't
	*   malloc like they want.
	*
	*   First do the update functions on the dimensions and/or
	*   set the timeout flags on the expired timers.  `Same' array
	*   holds other timers that may be expiring at the same time
	*   as `cur'.
	*
	*   Next subtract `cur_time' msec from all timers except `cur' and
	*   any on the `same' list.  Also skip timers not set.  Save
	*   shortest time for the next round.
	*
	*   Next reset `cur' to the interval value or shut it down.  
	*   If any on `same' list, do them too.  Screen these also to 
	*   find shortest time.
	*
	*   After all times are updated, go through the list looking
	*   for duplicates of shortest time.  Any found go on `same'
	*   list.  Next slot in `same' not used gets a -1 to mark end.
	*
	*   Finally reset the timer to the shortest time, which
	*   becomes `cur'.  In this version, the actual timer is
	*   set via the select statement out in the main loop, where
	*   this returns to with the number of msec to set, else 0. 
	*/
		new_timer_setting = -1;  /* clear this thing */

		if(dim[cur]) (*dim[cur]->timer_fn)(dim[cur]->param);
		if(flag[cur]) *flag[cur] = 1;
		for(i = 0; i < MT && same[i] != -1; ++i)
		{
			if(dim[same[i]]) 
			    (*dim[same[i]]->timer_fn)(dim[same[i]]->param);
			if(flag[same[i]]) *flag[same[i]] = 1;
		 }

	/*  Timers will be set and stopped through the timer callback
	*   functions that have gone on above.  If a new timer has been
	*   set, then the next time to select on will already be figured
	*   out, and all the stuff that follows will have been done already.
	*   Since toolkit callbacks are void, I'm using this global thing.
	*/
		if(new_timer_setting != -1)
		{
			return(new_timer_setting);
		 }

		/* set next to the first non -1 timer */
		for(next = 0; next < MT; ++next)
		{
			if(time[next] != -1 
			    && next != cur
			    && ! (same_mask & set_bit[next])) break;
		 }
  		if(next < MT)
		{
			next_time = time[next] -= cur_time;
		 }
		else
		{
			if(time[cur] == -1) /* a timer_fn has stopped clock*/
			{
				return(0);
			 }
			 next_time = 0;
		 }

		for(i = next + 1; i < MT; ++i)
		{
			if(i != cur 
			    && time[i] != -1 
			    && ! (same_mask & set_bit[i]))
			{
				if((time[i] -= cur_time) < next_time)
				{
					next = i;
					next_time = time[next];
			 	 }
			 }
		  }

		if(interval[cur])
		{
			time[cur] = interval[cur];
			if(time[cur] < next_time || ! next_time)
			{

				next = cur;
				next_time = time[cur];
			 }

		 }
		else
		{
			time[cur] = -1;
			dim[cur] = (Dimension *) 0;
			flag[cur] = (int *) 0;
			if(! (--ntimers))
			{
/*
*
*				value.it_interval.tv_sec = 0;
*				value.it_interval.tv_usec = 0;
*				value.it_value.tv_sec = 0;
*				value.it_value.tv_usec = 0;
*				if(setitimer(ITIMER_REAL,&value,&ovalue )== -1)
*				{
*					printf("%s: fault stopping timer\n",
*					    func);
*					return (-1);
*			 	 }
*				if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
*				{
*				  printf("%s: fault resetting signal handler\n"
*				     ,func);
*				  return(-1);
*		 	 	 }
*/
			  	return(0); /* stop clock */
			 }
		 }

		if(same_mask)
		{

			for( i = 0; i < MT && same[i] != -1; ++i)
			{
				if( interval[same[i]])
				{
					time[same[i]] = interval[same[i]];
					same_mask ^= set_bit[same[i]];
				 }
				else
				{
				  time[same[i]] = -1;
				  same_mask ^= set_bit[same[i]];
				  dim[same[i]] = (Dimension *) 0;
		  		  flag[same[i]] = (int *) 0;

				  interval[same[i]] = 0;
				  if( ! (--ntimers))
				  {
				     return(0);

/*				     value.it_interval.tv_sec = 0;
*				     value.it_interval.tv_usec = 0;
*				     value.it_value.tv_sec = 0;
*				     value.it_value.tv_usec = 0;
*				     if(setitimer(ITIMER_REAL,&value
*					,&ovalue )== -1)
*			  	     {
*				        printf("%s: fault stopping timer\n"
*					    ,func);
*					return (-1);
*			 	      }
*				     if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
*				     {
*					printf("%s: fault setting signal handler\n",func);
*					return(-1);
*		 	 	      }
*/
				    }
				 }
				if( time[same[i]] < next_time 
				    && time[same[i]] != -1)
				{
					next = same[i];
					next_time = time[next];
				 }
			 }

		 }
						 /* find duplicates */
		j = 0;
		for( i = 0; i < MT; ++i)          
		{
			if(time[i] == next_time  && i != next && next_time !=0)
			{

				same[j++] = i;
				same_mask |= set_bit[i];
			 }
		 }

		if(j < MT) same[j] = -1;
						/* reset timer	*/
		cur = next;
		cur_time = next_time;

/*		value.it_interval.tv_sec = 0;
*		value.it_interval.tv_usec = 0;
*		value.it_value.tv_sec = time[cur]/1000;
*		value.it_value.tv_usec = (time[cur]%1000)*1000;
*		if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
*		{
*			printf("%s: fault setting timer, `%d' msec\n"
*			    ,func,time[cur]);
*			return (-1);
*		 }
*/
		return (time[cur]);
}


/*-------------------------------------*/
start_timer(d, f, msec)
  Dimension	*d;
  int		*f;   
  int		msec;
{
  static char   	*func = "start_timer";
  struct itimerval  	value, ovalue;
  static int		timers_decremented = 0;
  int			oldmask;
  int			new, next, next_time, elapsed;
  int			i, j;

	oldmask = sigblock ( 1<<SIGALRM ); 

	for(new = 0; new < MT && time[new] != -1; ++new);
	if( new >= MT)
	{
		printf("%s: no timers left\n", func);
		sigsetmask( oldmask );
		return(-1);
	 }

	if(++ntimers == 1)
	{
							/* add new timer */
	  	dim[new] = d ? d : 0;
		time[new] = msec ? msec : d->interval;
		flag[new] = f;
		interval[new] = msec ? 0 : d->interval;
							/* watch SIGALRM  */
/*		if( (int)signal(SIGALRM, update_timers) == -1 )
*		{
*			printf("%s: setting signal handler\n",func);
*			sigsetmask( oldmask );
*			return (-1);
*		}
*/							/* start timer  */
printf("%s: setting timer to %d msec\n",func,time[new]);
		cur = new;
     	/*  The new_timer_setting that follows is the global flag that
	*  lets the update procedure know that a new timer has been set
	*  and a lot of the stuff it usually does is taken care of.
	*/
		new_timer_setting = cur_time = time[new];

	 }
  	else
	{
							/* adjust old timers */

		/* set next to the first non -1 timer */
		for(next = 0; next < MT && time[next] == -1; ++next);

		if( !timers_decremented )
		{
			next_time = time[next] -= cur_time;
		 }
		else    next_time = time[next];

		for(i = 0; i < MT; ++i)
		{
			if( !timers_decremented && time[i] != -1)
			{
				time[i] -= cur_time;
			 }

			if( time[i] != -1 && time[i] < next_time )
			{
				next = i;
				next_time = time[next];
			 }
		 }
							/* add new timer */
		dim[new] = d ? d : 0;
		time[new] = msec ? msec : d->interval;
		flag[new] = f;
		interval[new] = msec ? 0 : d->interval;
		if(time[new] < next_time)
		{
			next = new;
			next_time = time[new];
		 }
					       		/*  find duplicates  */
		j = 0;
		for(i = 0; i < MT; ++i)
		{
			if(time[i] == next_time && i != next)
			{
				same[j++] = i;
				same_mask |= set_bit[i];
			 }
		 }
		if(j < MT) same[j] = -1;
							/* reset timer    */
		cur = next;
		new_timer_setting = cur_time = next_time;
	 }

	return(0);
}


/*-------------------------------------*/
stop_timer(d)
   Dimension	*d;
{
   static char  *func = "stop_timer";
   struct itimerval  	value, ovalue;
   int 		oldmask, i;

	oldmask = sigblock ( 1<<SIGALRM );
printf("%s: ntimers = %d\n",func,ntimers);
   	if(ntimers)
	{
		for(i = 0; i < MT && dim[i] != d; ++i)
		if( i >= MT)
		{
			printf("%s: dimension `%s' is not currently timed\n"
		    	    ,func,d->name);
			sigsetmask( oldmask );
			return(0);
	 	 }
		time[i] = -1;
		interval[i] = 0;
		dim[i] = (Dimension *) 0;
        	flag[i] = (int *) 0;

		if(--ntimers == 0)
		{
printf("%s: stopping the system itimer\n",func);
			new_timer_setting = 0;
/*
			value.it_interval.tv_sec = 0;
			value.it_interval.tv_usec = 0;
			value.it_value.tv_sec = 0;
			value.it_value.tv_usec = 0;
			if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
			{
				printf("%s: fault stopping timer");
				sigsetmask( oldmask );
				return (-1);
		 	 }
			if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
		 	{
				printf("%s: fault resetting signal handler\n"
				    ,func);
				sigsetmask( oldmask );
				return(-1);
		 	 }
*/
	 	 }
	 }
	sigsetmask( oldmask );
	return(0);
}
	
/*-------------------------------------*/
static int mpause_flag;

trigger_mpause()
{
	mpause_flag = -1;
}

mpause( msec )
     int	msec;
{
	char  *func = "mpause";
    	struct itimerval  	value, ovalue;

	mpause_flag = 0;

	if( (int)signal(SIGALRM, trigger_mpause) == -1 )
	{
		printf("%s: setting signal handler\n",func);
		return (-1);
	}

	value.it_interval.tv_sec = 0;
	value.it_interval.tv_usec = 0;
	value.it_value.tv_sec = msec/1000;
	value.it_value.tv_usec = (msec%1000)*1000;
	if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
	{
		printf("%s: fault setting timer, `%d' msec\n"
		    ,func,msec);
		return (-1);
	 }

	while( ! mpause_flag );

	if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
 	{
		printf("%s: fault resetting signal handler\n"
		    ,func);
		return(-1);
 	 }

	return (0);
}
/*-------------------------------------*/
/*  Temporarily suspended

mpause( msec )
  int	msec;
{
  int	flag = 0;
  char  *func = "mpause";

printf("%s\n");
	if( start_pause(&flag,msec) == -1 )
		return (-1);
	while( !flag );
	return (0);
}

*/


