#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <X10/Xlib.h>
#define AUX 
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"

/* Get_time_remaining and getelapsed are called from main and timers. */
/*-------------------------------------*/
get_time_remaining(msecs, start)
	int		msecs;
	struct timeval 	*start;
{

  	struct timeval        ed, *end = &ed;
  	struct timezone       tmz, *timezone = &tmz;
	int	elapsed;

	if(msecs)
	{
		gettimeofday(end,timezone);
	        elapsed = ((end->tv_sec - start->tv_sec) * 1000);
		elapsed += (end->tv_usec / 1000);
		elapsed -= (start->tv_usec / 1000);
		msecs -= elapsed;
	 }
	return (msecs);
}

/*-------------------------------------*/
getelapsed(start)
  struct timeval	*start;
{
  struct timeval        ed, *end = &ed;
  struct timezone       tmz, *timezone = &tmz;
  int			msecs, sec;

        gettimeofday(end,timezone);  		
        processing_time = ((end->tv_sec - start->tv_sec) * 1000);
	processing_time += (end->tv_usec / 1000);
	processing_time -= (start->tv_usec / 1000);

	/* processing_time is a global used in the pace routine; holds
	*  a `present-weighted' average of processing time
	*/
	processing_avg = (processing_avg + processing_time)/2;

/*printf("end sec `%d', usec `%d'; start sec `%d', usec `%d', processing_time `%d'\n",
*	end->tv_sec, end->tv_usec, start->tv_sec, start->tv_usec,processing_time);
*/
	return (processing_time);
}

/*---------------------------------------*/
void
signal_unexpected(what,funcname,linecount)
 char *what, *funcname;
 int linecount;
{
printf("%s: Unexpected %s at line %d.\n",funcname,what,linecount);
exit(1);
}


void
signal_missing_data(what,funcname,linecount)
     char *what, *funcname;
     int linecount;
{
  printf("%s: Missing %s at line %d\n",funcname,what,linecount);
}



void
screen_error(s, part,lkup)
  Screen	*s;
  char 		*part;
  Lkup_union    *lkup;
{
  static char 	*funcname = "Screen_error";

  if(strlen(s->name)){
	  printf("%s: bad %s for screen %s\n",funcname,part,s->name);
	  printf("screen: %s, type %s, pos %d,%d, size %d,%d, parent %s, bdrwdth %d, border %d, bckgnd %d\n",
		   s->name,lkup->name, s->x,s->y,s->width,s->height,
		   s->parentname, s->borderwidth, s->border,s->background);
 	  exit(1);
   }
  else
  {
	  printf ("%s: bad %s for screen after %s\n",
		  funcname,part,s->prev->name);
	  printf("screen: %s, type %d, pos %d,%d, size %d,%d, parent %s, bdrwdth %d, border %d, bckgnd %d\n",
		   s->name,lkup->name, s->x,s->y,s->width,s->height,
		   s->parentname, s->borderwidth, s->border,s->background);
	  exit(1);
    }
}


char *index();

char *
parse(type,x,p1)
   int 		type;
   int 		*x;
   char		*p1;
{
   char		*p2, tmp[Nchars];

	if(index(p1,','))
	{
	        p2 = index(p1,',');
	  	*p2 = '\0';
		if(type == Str)
		{ 
			strcpy((char *) tmp, p1);
			sscanf(tmp,"%s",x);
		
		 }
		else if(type == Num) *x = atoi(p1);
	  	p1 = ++p2;
	  	return p1;
	 }

	else if(index(p1,'('))
	{
	        p2 = index(p1,'(');
	  	*p2 = '\0';
		if(type == Str)
		{ 
			strcpy((char *) tmp, p1);
			sscanf(tmp,"%s",x);
		
		 }
		else if(type == Num) *x = atoi(p1);
	  	p1 = ++p2;
	  	return p1;
	 }


        else
	{
		if((p2 = index(p1,')')) != 0)
		{
	  		*p2 = '\0';
			if(type == Str)
			{
				strcpy((char *) x, p1);
				sscanf(tmp,"%s",x);
			 }
			else if(type == Num) *x = atoi(p1);
	  		p1 = ++p2;
	  		return p1;
	 	 }

 		else return (char *) NULL;
	 }
}



char *
get_data_line(fp)
  FILE 		*fp;
{
  static char   *funcname = "get_data_line";
  static char 	line[Nchars];

	while( !feof(fp)){
  		++linecount;
  		fgets(line, Nchars, fp);
		switch(line[0]){
			case '#':
			case ' ':
			case '\t':
			case '\n':
				break;
			default:
				return(line);
		 }
	 }
	return (char *) NULL;
}



get_graphic_point(i,s,m)
     int 	i;
     char	*s;
     Map	*m;
{
	static char	*func = "get_graphic_point";
	char		*p;
	Lkup_union 	lkp, *lkup = &lkp;
	char		*index();
		if( (p = index(s,'(')) != 0)
		{
			m->graphic.params[i] = newstr(p);
			*p = '\0';

			strcpy(lkup->name,s);

      			if((m->graphic.fn[i] = 
			    (int(*)()) lookup_function(Key, lkup)) == NULL)
			{
	  		     printf("%s: bad function name `%s' in line %d\n",
			       	func, lkup->name, linecount);
		 	 } 
		 }
		else
		{
      			m->graphic.value[i] = atoi(s);
		 }			

}



  Packpos *
make_packpos(args)
  char * args;
{
	static char *func = "ev_set_position";
	Packpos	*p;
	char 	*p1,*p2,c[Nchars];
	char    *index();
	int	x,i;

	if((p = (Packpos *)calloc(1, sizeof(Packpos))) == NULL)
	{
		printf("%s: failed calloc Packpos\n",func);
	 }

        p1 = args + 1;
	if((p1 = parse(Num,&x,p1)) == NULL)
	{
		printf("%s: expects number as first param\n");
	 }
	p->bypass = x;

	if((p1 = parse(Str,c,p1)) == NULL)
	{
		printf("%s: bad parameter in line %d\n"
		    ,func,linecount);
	 }
	p->pname = newstr(c);

	for(i=0; i < MaxDims; ++i)
	{
        	p1 = parse(Num,&x,p1); 
		p->pos[i] = x;
 	}
	return(p);
/*	p->e = e; */


}






