/*
 *	$Source: /mit/projects/visual/RCS/lookups.c,v $
 *	$Header: lookups.c,v 1.4 87/07/08 09:59:23 joelr Exp $
 */

#include <stdio.h>
#include <X10/Xlib.h>
#include </mit/visual/tools/include/X10/Xtlib.h>
#define LKUPS  
#define READFILE extern
#define AUX extern
#include "prsdefs.h"
#include "lkups.h"
#define FN_MISC extern
#define SETPOS extern
#include "functions.h"
#define DISPLAYS extern
#include "dspdefs.h"



int 
lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "package", 		1,
    "dataset",          2,
    "element", 		2,
    "screenset", 	3,
    "screen", 		4,
    "map", 		5,
    "dimension", 	6,
    "timer", 		7,
    "include", 		8,
    "name", 		9,
    "next", 		10,
    "type", 		11,
    "active", 		12,
    "label", 		13,
    "in", 		14,
    "out", 		15,
    "icon", 		16,
    "filename", 	17,
    "pos_in", 		18,
    "pos_out", 		19,
    "max",		20,
    "min", 		21,
    "range", 		22,
    "boundary", 	23,
    "screen_name", 	24,
    "parent", 		25,
    "xpos", 		26,
    "ypos", 		27,
    "width", 		28,
    "height", 		29,
    "borderwidth", 	30,
    "border", 		31,
    "background", 	32,
    "key_dimension", 	33,
    "timer_fn", 	34,
    "parameter", 	35,
    "rate", 		36,
    "represents", 	37,
    "funt", 		38,
    "foreground", 	39,
    "x1", 		40,
    "y1", 		41,
    "x2", 		42,
    "y2", 		43,
    "rowcol", 		44,
    "offset", 		45,
    "xoverlap", 	46,
    "yoverlap", 	47,
    "on_open",          48,
    "on_close",         49,
    "key_x",            50,
    "key_y",            51,
    "initial",		52,
    "action",           53
    };

  for(i=0;i<NKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}






 char *
lookup_type(what,lkup)    /*   element types  */
 int 		what;
 Lkup_union 	*lkup;

{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[TKEYS] = {
    "video", 		 1,
    "still", 		 2,
    "text", 		 3,
    "tk_widget", 	 4,
    "window", 		 5,
    "transparency", 	 6,
    "complex", 		 7,
    "audio", 		 8,
    "free_video", 	 9,
    "graphic", 		10,
    "action",		11,
    "package",		12
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<TKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
 	 }
	else
	{
  		for(i=0;i<TKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}




#define DFKEYS 		10

 char *
lookup_dsp_fn(what,lkup)    /*   type  */
 int 		what;
 Lkup_union 	*lkup;

{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    char *value;
  } table[DFKEYS] = {
    "audio", (char *) display_audio,
    "video", (char *) display_video,
    "still", (char *) display_still,
    "text", (char *) display_text,
    "tk_widget", (char *) display_TKwidget,
    "complex", (char *) display_complex,
    "free_video", (char *) free_video,
    "graphic", (char *) display_graphic,
    "package", (char *) display_package,
    "action", (char *) display_action
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) != 0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<DFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
 	 }
	else
	{
  		for(i=0;i<DFKEYS;++i)
		{
    			if((int)table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}


#define BKEYS 5  /*    Boundary  */

 char * 
lookup_boundary(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[BKEYS] = {
    "wrap",1,
    "freeze", 2,
    "bounce", 3,
    "limit", 4,
    "expire", 5
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<BKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else
	{
  		for(i=0;i<BKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
        			return((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}





 char *
lookup_active(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[AKEYS] = {
    "yes", 1,
    "no", 0,
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<AKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<AKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}



 char *
lookup_map_type(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[MKEYS] = {
    "still", 0,
    "video", 1,
    "complex", 2,
    "line", 3,
    "button", 4,
    "tkdialog", 5,
    "tkscroll", 6,
    "tktext", 7,
    "label", 8,
    "box", 9,
    "arc", 10
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<MKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<MKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}



#define TKFKEYS 19

 char *
lookup_function(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    char *value;
    int	 param;
  } table[TKFKEYS] = {
    "quit", (char *) quit, NULL,
    "grabvideo", (char *) grabvideo, PACKPOS_PARAM,
    "StringFunction", (char *) StringFunction, STRING_PARAM,
    "video", (char *) video, STRING_PARAM,
    "scroll", (char *) scroll, NULL,
    "thumb", (char *) thumb, NULL,
    "set_position", (char *) set_position, PACKPOS_PARAM,
    "rset_position", (char *) rset_position, PACKPOS_PARAM,
    "pace", (char *) pace, PACKPOS_PARAM,
    "do_next", (char *) do_next, PACKPOS_PARAM,
    "do_prev", (char *) do_prev, PACKPOS_PARAM,
    "switch_to", (char *) switch_to, PACKPOS_PARAM,
    "expire", (char *) expire, PACKPOS_PARAM,
    "activate", (char *) activate, PACKPOS_PARAM,
    "activate_reset", (char *) activate_reset, PACKPOS_PARAM,
    "scroll_control_package", (char *) scroll_control_package, PACKPOS_PARAM,
    "set_label_equal", (char *) set_label_equal, STRING_PARAM,
    "glossary_lookup", (char *) glossary_lookup, PACKPOS_PARAM,
    "set_rate", (char *) set_rate, PACKPOS_PARAM
    };

	switch(what)
	{
	   case Key:
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 
		break;
	 
	   case Val:
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(table[i].value == (char *)lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
		break;

	   case Param:
		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].param);
    			 }
  		 }
	 
		break;
	 
	 }
	return ((char *) FAILURE);
}






int 
TK_lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[TKkeys] = {
    "window", 1,
    "label", 2, 
    "font", 3,
    "borderwidth", 4,
    "foreground", 5,
    "background", 6,
    "border", 7,
    "width", 8,
    "height", 9,
    "justify", 10,
    "function", 11,
    "parameter", 12,
    "highlight", 13,
    "unhighlight", 14,
    "notify", 15,
    "orientation", 16,
    "thumb", 17,
    "scrollupdownproc", 18,
    "thumbproc", 19,
    "top", 20,
    "shown", 21,
    "hspace", 22,
    "vspace", 23,
    "dialogvalue", 24,
    "dialogbutton", 25,
    "name", 26,
    "x", 27,
    "y", 28,
    "value", 29,
    "pos_in", 30,
    "pos_out",31,
    "edit_type", 32,
    "text_options",    	33,
    "display_position", 34,
    "insert_position",	35,
    "left_margin",		36,
    "file",			37,
    "string",		38,
    "length",		39,
    "event_bindings",	40,
    "entry",		41
    };

  for(i=0;i<TKkeys;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}


#define TKtext_edit_modes       3

 char *
lookup_TKtext_edit_mode(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[TKtext_edit_modes] = {
    "read", (int) XttextRead,
    "append",(int)  XttextAppend,
    "edit", (int) XttextEdit
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKtext_edit_modes;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<TKtext_edit_modes;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}

