
environment Xtest
{

	-- declarations section; all of the C globals which can be accessed

	on OpenEnv
	{
		put GetAFont( "timrom12b" ) into theFont;
		put MakeCursor( "left_ptr.cursor", "left_ptr_mask.cursor",
			"black", "white" ) into theCursor;
		XDefineCursor( theRoot(), theCursor );
		put TextCreate( 80,24,750,100,theRoot(),
			"8x13",2,0,1,BlackPM(),1 ) into TextWinPtr;
		RegisterTW( TextWinPtr );	-- VERY IMPORTANT!!
		put WindowFromTW( TextWinPtr ) into theTextWindow;
		MapWindow( theTextWindow );

		put MakeButtonBox( theRoot(), 550,100,300,100 ) into bbw;
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Beep" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Edit File" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Close" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Quit" ) );

		MapWindow( bbw );
		MapChildren( bbw );
		FlushEvents();


		send "Initialize" to "digit";

	}


	object Close
	{
		on Activate
		{
			if( theEditor > 0 ) 
			{
				XtSendDestroyNotify( theEditor );
				XDestroyWindow( theEditor );
				put 0 into theEditor;
			}
			if( theMenu > 0 )
			{
				XDestroyWindow( theMenu );
				put 0 into theMenu;
			}
		}	
	}

	object "Edit File"
	{
		var DialogWaiting;
		var DialogWindow;

		on Activate
		{
			if( DialogWaiting > 0 ){ exit Activate; }
			if( theEditor > 0 ) { exit Activate; }
			put MakeAskFor( theRoot(), 
				"Enter name of file to edit:", "xtk.xs", 
				550, 175 ) into DialogWindow;
			MapWindow( DialogWindow );
			put 1 into DialogWaiting;
		}

		on okay
		{
			put GetAskForString( DialogWindow ) into theFile;
			UnMap( DialogWindow );
			put 0 into DialogWaiting;
			put MakeMenuBarWindow( theRoot(), "Text Editor",
				50, 200, ((80*6)+40), ((24*10)+40) ) into theMenu;
			put MakeTextEditor( theMenu, theFile,
				20, (MenuBarHeight()+20), (80*6), (24*10)  ) 
				into theEditor;
			if( theEditor = 0 )
			{ 
				put "Unable to edit file" into theResult;
				TextPutLine( TextWinPtr, "Unable to edit file" );
				exit okay;
			}
			if( theMenu > 0 ) 
			{
				put (((("SetIcon "&theMenu)&" `Text Editor: ")&theFile)&"`")
					into theMsg;
				send theMsg to "IconWindow";
				MapWindow( theMenu ); 
				MapChildren( theMenu );
				MapWindow( theEditor );
			}

		}

		on cancel
		{
			UnMap( DialogWindow );
			put 0 into DialogWaiting;
			TextPutLine( TextWinPtr, "Cancel selected" );
		}
	}

	object IconWindow
	{
		var	myPixmap;
		var	theIcon;
		var	IconW;
		var	IconH;
		var	IconWindowW;
		var	IconWindowH;
		var	IconName;

		on SetIcon	mainWindow,theName
		{
			put (("SetIcon: "&mainWindow)&(" "&theName)) into text;
			TextPutLine( TextWinPtr, text );
			if( myPixmap = 0 )
			{
				put MakePixmap( "menuicon.bitmap", 
					"Firebrick", "CadetBlue", IconW, IconH ) 
						into myPixmap;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				put MakeWindow( theRoot(), 100, 100, 
					IconWindowW, IconWindowH,
					2, BlackPM(), WhitePM() )
						into theIcon;
				RegisterWindow( theIcon, theObj() );
			}
			else	-- icon already made, name may have changed
			{
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				ChangeWindow( theIcon, IconWindowW, IconWindowH );
			}
			put theName into IconName;
			SetIconWindow( mainWindow, myWindow() );
		}

		on ExposeWindow
		{
			PlotIcon( myWindow(), myPixmap, IconW, IconH, IconName, theFont );
		}

		on ExposeRegion
		{
			PlotIcon( myWindow(), myPixmap, IconW, IconH, IconName, theFont );
		}

		on ButtonPressed
		{
			IconSwitch( myWindow() );
		}
	}

	object "Text Editor"
	{
		on NameHit
		{
			TextPutLine( TextWinPtr, "Hit Namebar" );
			IconSwitch( theMenu );
		}

		on MenuHit	menu,item
		{
			put ("Menu: "&menu) into p1;
			put ("; Item: "&item) into p2;
			put (p1 & p2) into text;
			TextPutLine( TextWinPtr, text );
			if( menu = "File" )
			{
				if( item = "Close" )
					{ send "Activate" to "Close"; }
			}
			else if( menu = "Edit" )
			{ 
				if( item = "Cut" )
				{
					GetTextEditorPos( theEditor, beg, end );
					GetTextEditorSelection( nbytes );
					TextPutLine( TextWinPtr, 
						(("Cut: "&beg)&(","&end)) );
					TextEditorReplace( theEditor, beg, end, "");
					SetTextEditorPos( theEditor, beg, beg );
				}
				else if( item = "Copy" )
				{
					GetTextEditorPos( theEditor, beg, end );
					GetTextEditorSelection( nbytes );
					TextPutLine( TextWinPtr, 
						(("Cut: "&beg)&(","&end)) );
					TextEditorReplace( theEditor, beg, end, 
						theTextBuffer );
				}
				else if( item = "Paste" )
				{
					XtTextUnsetSelection( theEditor );
					GetTextEditorPos( theEditor, beg, end );
					TextEditorReplace( theEditor, beg, beg, 
						theTextBuffer );
				}
			}
		}
	}

	object Okay
	{
		on Activate
		{ send "okay" to "Edit File"; }
	}

	object Cancel
	{
		on Activate
		{ send "cancel" to "Edit File"; }
	}

	object Beep { on Activate { Beep(); } }

	object digit
	{ 
		var packptr;
		
		on Initialize
		{
			put GetPackagePtr( "test" ) into packptr;
		 }

		on ButtonReleased x, y, mask
		{ 

			evsetxy( packptr,0,x,1,y);
			evsetxy( packptr,2,x,0,x);
		}

	}

	object Quit { on Activate { Quit(); } }

}
