
environment app
{
-- ============ C declarations =============
Cint theTextBuffer;
Cfunc theObj(  ) returns Cstr;
Cfunc theEnv(  ) returns Cstr;
Cfunc theCode(  ) returns Cstr;
Cfunc XtTextUnsetSelection( Cint );
Cfunc GetTextEditorPos( Cint, Cstr, Cstr );
Cfunc SetTextEditorPos( Cint, Cint, Cint );
Cfunc GetTextEditorSelection( Cstr ) returns Cint;
Cfunc TextEditorReplace( Cint, Cint, Cint, Cstr );
Cfunc QueryWindow( Cint, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
Cfunc ChangeWindow( Cint, Cint, Cint );
Cfunc QueryHeight( Cint ) returns Cint;
Cfunc XQueryWidth( Cstr, Cint ) returns Cint;
Cfunc GXCOPY(  ) returns Cint;
Cfunc ALLPLANES(  ) returns Cint;
Cfunc myWindow(  ) returns Cint;
Cfunc GetAFont( Cstr ) returns Cint;
Cfunc ShowText( Cint, Cint, Cint, Cstr, Cint, Cint, Cint );
Cfunc theRoot(  ) returns Cint;
Cfunc WhitePM(  ) returns Cint;
Cfunc BlackPM(  ) returns Cint;
Cfunc MakeWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
Cfunc RegisterWindow( Cint, Cstr );
Cfunc MapWindow( Cint );
Cfunc MapChildren( Cint );
Cfunc UnMap( Cint );
Cfunc ClearWindow( Cint );
Cfunc strlen( Cstr ) returns Cint;
Cfunc FlushEvents(  );
Cfunc Beep(  );
Cfunc MoveWindow( Cint, Cint, Cint );
Cfunc MakeButton( Cint, Cint, Cint, Cstr ) returns Cint;
Cfunc MakeButtonBox( Cint, Cint, Cint, Cint, Cint ) returns Cint;
Cfunc AddToButtonBox( Cint, Cint );
Cfunc MakeAskFor( Cint, Cstr, Cstr, Cint, Cint ) returns Cint;
Cfunc GetAskForString( Cint ) returns Cstr;
Cfunc MakeTextEditor( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
Cfunc XtSendDestroyNotify( Cint );
Cfunc XDestroyWindow( Cint );
Cfunc Quit(  );
Cfunc MakeMenuBarWindow( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
Cfunc MenuBarHeight(  ) returns Cint;
Cfunc SetIconWindow( Cint, Cint );
Cfunc IconSwitch( Cint );
Cfunc MakePixmap( Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
Cfunc XPixmapPut( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );
Cfunc MakeCursor( Cstr, Cstr, Cstr, Cstr ) returns Cint;
Cfunc XDefineCursor( Cint, Cint );
Cfunc XUndefineCursor( Cint );
Cfunc GetColor( Cstr ) returns Cint;
Cfunc RegisterTW( Cint );
Cfunc DeRegisterTW( Cint );
Cfunc WindowFromTW( Cint ) returns Cint;
Cfunc TextCreate( Cint, Cint, Cint, Cint, Cint, Cstr, Cint, Cint, Cint, Cint, Cint ) returns Cint;
Cfunc TextDestroy( Cint );
Cfunc TextClear( Cint );
Cfunc TextRedisplay( Cint );
Cfunc TextPutString( Cint, Cstr );
Cfunc TextPutChar( Cint, Cint );
Cfunc TextPutLine( Cint, Cstr );
Cfunc TextFlush( Cint );

-- ============ Global vars =============

	var theTextBuffer;

-- ============ Global code segs =============
<< Cfunc 'theObj' >>
<< Cfunc 'theEnv' >>
<< Cfunc 'theCode' >>
<< Cfunc 'XtTextUnsetSelection' >>
<< Cfunc 'GetTextEditorPos' >>
<< Cfunc 'SetTextEditorPos' >>
<< Cfunc 'GetTextEditorSelection' >>
<< Cfunc 'TextEditorReplace' >>
<< Cfunc 'QueryWindow' >>
<< Cfunc 'ChangeWindow' >>
<< Cfunc 'QueryHeight' >>
<< Cfunc 'XQueryWidth' >>
<< Cfunc 'GXCOPY' >>
<< Cfunc 'ALLPLANES' >>
<< Cfunc 'myWindow' >>
<< Cfunc 'GetAFont' >>
<< Cfunc 'ShowText' >>
<< Cfunc 'theRoot' >>
<< Cfunc 'WhitePM' >>
<< Cfunc 'BlackPM' >>
<< Cfunc 'MakeWindow' >>
<< Cfunc 'RegisterWindow' >>
<< Cfunc 'MapWindow' >>
<< Cfunc 'MapChildren' >>
<< Cfunc 'UnMap' >>
<< Cfunc 'ClearWindow' >>
<< Cfunc 'strlen' >>
<< Cfunc 'FlushEvents' >>
<< Cfunc 'Beep' >>
<< Cfunc 'MoveWindow' >>
<< Cfunc 'MakeButton' >>
<< Cfunc 'MakeButtonBox' >>
<< Cfunc 'AddToButtonBox' >>
<< Cfunc 'MakeAskFor' >>
<< Cfunc 'GetAskForString' >>
<< Cfunc 'MakeTextEditor' >>
<< Cfunc 'XtSendDestroyNotify' >>
<< Cfunc 'XDestroyWindow' >>
<< Cfunc 'Quit' >>
<< Cfunc 'MakeMenuBarWindow' >>
<< Cfunc 'MenuBarHeight' >>
<< Cfunc 'SetIconWindow' >>
<< Cfunc 'IconSwitch' >>
<< Cfunc 'MakePixmap' >>
<< Cfunc 'XPixmapPut' >>
<< Cfunc 'MakeCursor' >>
<< Cfunc 'XDefineCursor' >>
<< Cfunc 'XUndefineCursor' >>
<< Cfunc 'GetColor' >>
<< Cfunc 'RegisterTW' >>
<< Cfunc 'DeRegisterTW' >>
<< Cfunc 'WindowFromTW' >>
<< Cfunc 'TextCreate' >>
<< Cfunc 'TextDestroy' >>
<< Cfunc 'TextClear' >>
<< Cfunc 'TextRedisplay' >>
<< Cfunc 'TextPutString' >>
<< Cfunc 'TextPutChar' >>
<< Cfunc 'TextPutLine' >>
<< Cfunc 'TextFlush' >>

GetIconWindowSize( iw, ih, name, f, width, height )
{
var strWidth;
var strHeight;
var w;
var h;

  put XQueryWidth( name , f  ) into strWidth ;
  put QueryHeight( f  ) into strHeight ;
  put ( strWidth + 20 ) into w ;
  if ( ( iw + 20 ) > w ) 
  {
    put ( iw + 20 ) into w ;
  } 
  put ( ( strHeight + ih ) + 30 ) into h ;
  put w into width ;
  put h into height ;
} 

PlotIcon( window, pm, iw, ih, name, f )
{
var w;
var h;
var x;
var y;
var bdr;
var mapped;
var type;
var assoc;
var destSX;
var destSY;
var destIX;
var destIY;

  QueryWindow( window , w , h , x , y , bdr , mapped , type , assoc  ) ;
  put 10 into destSX ;
  put ( ih + 20 ) into destSY ;
  put ( ( w - iw ) / 2 ) into destIX ;
  put 10 into destIY ;
  XPixmapPut( window , 0 , 0 , destIX , destIY , iw , ih , pm , GXCOPY(  ) , ALLPLANES(  )  ) ;
  ShowText( window , destSX , destSY , name , strlen( name  ) , f , 0  ) ;
} 

-- ============ Object list =============

object IconWindow
{
var myPixmap;
var myFont;
var theIcon;
var IconW;
var IconH;
var IconWindowW;
var IconWindowH;
var IconName;


on SetIcon	mainWindow, theName, theFont
{
var text;

  put ( ( "SetIcon: " & mainWindow ) & ( " " & theName ) ) into text ;
  if ( myPixmap = 0 ) 
  {
    put theFont into myFont ;
    put MakePixmap( "menuicon.bitmap" , "Firebrick" , "CadetBlue" , IconW , IconH  ) into myPixmap ;
    GetIconWindowSize( IconW , IconH , theName , myFont , IconWindowW , IconWindowH  ) ;
    put MakeWindow( theRoot(  ) , 100 , 100 , IconWindowW , IconWindowH , 2 , BlackPM(  ) , WhitePM(  )  ) into theIcon ;
    RegisterWindow( theIcon , theObj(  )  ) ;
  } 
  else 
  {
    GetIconWindowSize( IconW , IconH , theName , myFont , IconWindowW , IconWindowH  ) ;
    ChangeWindow( theIcon , IconWindowW , IconWindowH  ) ;
  } 
  put theName into IconName ;
  SetIconWindow( mainWindow , myWindow(  )  ) ;
} 

on ExposeWindow
{

  PlotIcon( myWindow(  ) , myPixmap , IconW , IconH , IconName , myFont  ) ;
} 

on ExposeRegion
{

  PlotIcon( myWindow(  ) , myPixmap , IconW , IconH , IconName , myFont  ) ;
} 

on ButtonPressed
{

  IconSwitch( myWindow(  )  ) ;
} 
} -- ====== end of object 'IconWindow' ====

} -- ======= end of ENVIRONMENT 'app'

