
#include <stdio.h>
#include "ev_tokens.h"
#include "MemAssoc.h"

extern char *calloc();

extern ENV_PTR	curenv;
extern OBJ_PTR	curobj;
extern CODE_PTR curcode;

static MemAssocTable *	XferTable = NULL;

int
ev_merge_EveryThing( clist, elist )
	C_DCL_PTR	clist;
	ENV_PTR		elist;
{
C_DCL_PTR	cdp;
CODE_PTR	cp;
OBJ_PTR		op;
HashNodePtr	hnp;

	XferTable = MemCreateAssocTable( 64 );
/*
	if( clist == NULL )
		printf("new Clist is NULL\n");
	if( elist == NULL )
		printf("new Elist is NULL\n");
*/
/*
	printf("entire env BEFORE merge:\n");
	dump_env( envlist );
*/
/*
	if( envlist )
	{
		printf("BEFORE merge objlist:\n");
		for( op = envlist->objlist; op; op=op->next )
		{
			printf("object: '%s'\n",op->name);
			hnp = hash_lookup( envlist->obj_ht, op->name );
			if( !hnp )
				printf("INTERNAL ERROR: object in list not in table\n");
			if( hnp->ptr != (char *) op )
				printf("INTERNAL ERROR: object in table doesn't match one in list\n");
		}
	}
*/
	ev_merge_CdecList( clist );
	ev_merge_Env( envlist, elist );
	MemDestroyAssocTable( XferTable );
	XferTable = NULL;
/*
	if( envlist )
	{
		printf("AFTER merge objlist:\n");
		for( op = envlist->objlist; op; op=op->next )
		{
			printf("object: '%s'\n",op->name);
			hnp = hash_lookup( envlist->obj_ht, op->name );
			if( !hnp )
				printf("INTERNAL ERROR: object in list not in table\n");
			if( hnp->ptr != (char *) op )
				printf("INTERNAL ERROR: object in table doesn't match one in list\n");
		}
	}
*/
/*
	printf("entire env AFTER merge:\n");
	dump_env( envlist );
*/
	return 0;
}

/* 
	merges a temporary clist with the global C_declist;
*/

int
ev_merge_CdecList( new )	
	C_DCL_PTR	new;
{
C_DCL_PTR	tcp, next, temp;

	/* all of the pointers which do not get moved in must be changed,
		to point to different instances in the old env which
		supplant them */

	if( !XferTable )
	{
		printf("ev_merge_CdecList(): XferTable is NULL; try ev_merge_EveryThing()\n");
		return -1;
	}

	for( tcp = new, next = NULL; tcp; tcp = next )
	{
		next = tcp->next;
		temp = findCdcl( tcp->name );
		if( temp )
		{
			/* all refs to this ptr must be changed */
			MemMakeAssoc( XferTable, (MemId) tcp, (MemId) temp );
			free( (char *) tcp->name );
			free( (char *) tcp );
		}
		else
			addCdcl( tcp );			
	}
	return 0;
}

/* 	ev_merge_Env()

	merge two envs; all of new env is put into old; rules as follows:

	* name stays the same
	* global vars are added only if new
	* global constans are added only if new
	* global code segs are added only if no duplicate; else complains
	* objects are added only if new; else complains
*/
	
int
ev_merge_Env( old, new )

	ENV_PTR	old, new;
{
VAR_PTR	tvp, nextv, temp;
CODE_PTR tcp, nextc, tempc;
OBJ_PTR op, nexto;
int	i;
int *	ip;
MemId	newptr;

	/* 	
		all code segments that are brought in must have their pointers
		changed to locations created in the old env from the new;
		those that need changing are stored in the XferTable
	*/

	if( !XferTable )
	{
		printf("ev_merge_Env(): XferTable is NULL; try ev_merge_EveryThing()\n");
		return -1;
	}

	if( !old || !new )
		return -1;

	/* first, handle the global constants list */

	for( tvp = new->constants, nextv = NULL; tvp; tvp = nextv )
	{
		nextv = tvp->next;
		switch( tvp->type )
		{
		case T_int:
			if( (temp = findint(tvp->val.ival)) )
			{
				MemMakeAssoc( XferTable, (MemId) tvp, (MemId) temp );
			}
			else
			{
				addvar( &old->constants, tvp );
			}
			break;
		case T_string:
			if( (temp = findstr(tvp->val.sval)) )
			{
				MemMakeAssoc( XferTable, (MemId) tvp, temp );
			}
			else
			{
				addvar( &old->constants, tvp );
			}
			break;
		case T_float:
			if( (temp = findflt(tvp->val.fval)) )
			{
				MemMakeAssoc( XferTable, (MemId) tvp, temp );
			}
			else
			{
				addvar( &old->constants, tvp );
			}
			break;
		default:
			printf("mergeEnv: merge: ERROR: unknown type of constant\n");
			break;
		}
	}

	/* add in any new global vars */

	for( tvp = new->global_vars, nextv = NULL; tvp; tvp = nextv )
	{
/*		printf("adding in new global var: %s\n",tvp->name); */
		nextv = tvp->next;
		if( (temp = findvar(old->global_vars, tvp->name)) )
		{
			printf("found duplicate code segment '%s' in the old env!\n",tvp->name);
			printf("(NEW code OVER-RIDES the OLD)\n");
			MemMakeAssoc( XferTable, (MemId) tvp, (MemId) temp );
		}
		else
		{
			addvar( &old->global_vars, tvp );
		}
	}

	/* add in global code segments */

	for( tcp = new->global_code, nextc = NULL; tcp; tcp = nextc )
	{
/*		printf("adding new global code segment: %s\n",tcp->name); */
		nextc = tcp->next;
		if( (tempc = findcode(old->global_code,tcp->name)) )
		{
			if( tcp->type != CFUNC_CODESEG )
			{
				printf("\n");
				printf(">> ERROR: duplicate global codeseg '%s' found\n",
					tcp->name );
				printf(">> You can expect errors with any methods which use it.\n");
				printf(">> (this codeseg will reside in a separate memory segment)\n");
				printf("\n");
			}
			else
			{
				MemMakeAssoc( XferTable, (MemId) tcp, (MemId) tempc );
			}
		}
		else
		{
			addcode( &old->global_code, tcp );
		}
		
		/* transfer pointers in the code seg that are now part of old env */

		xfer_code( XferTable, tcp );
	}

	/* add in new objects */

	for( op = new->objlist, nexto = NULL; op; op = nexto )
	{
		nexto = op->next;
/*		printf("adding in new object: %s\n",op->name); */
		if( findobj(old, op->name) )
			printf("WARNING: overwriting object '%s' in old env!\n",op->name);
		addobj( old, op );
		/* transfer any refs to global vars in object that need to be changed */
		xfer_obj( XferTable, op );
	}

	return 0;
}

/* change any var ptrs in the fcall to the new code space if they have been duped */

int
xfer_fcall( table, code )
	MemAssocTable *table;
	long code;
{
int *	ip;
FCALL_PTR	fcp;
MemId	dup;
int	i;
int	err = 0;

	if( !table || !code )
		return -1;

	fcp = (FCALL_PTR) code;
	if( fcp->magic != FCALL_MAGIC )
		printf("xfer_fcall: ERROR: object is not an fcall\n");

	for( i=0; i<fcp->nparms; i++ )
	{
		ip = (int *) fcp->parms[i];
		switch( *ip )
		{
		case VAR_MAGIC:
			dup = MemLookUpAssoc( table, (long) fcp->parms[i] );
			if( dup )
				fcp->parms[i] = (char *) dup;
			break;
		case FCALL_MAGIC:
			xfer_fcall( table, (long) fcp->parms[i] );
			break;
		case EXPR_MAGIC:
			xfer_expr( table, (long) fcp->parms[i] );
			break;
		default:
			printf("xfer_fcall: ERROR: unknown type of thing, parm #%d\n",i+1);
			break;
		}
	}

	/* change function if it's a C-func that is old */
	dup = MemLookUpAssoc( table, (long) fcp->func );
	if( dup )
		fcp->func = (CODE_PTR) dup;
	return 0;
}

/* change any var ptrs in the expr to the new code space if they have been duped */

int
xfer_expr( table, code )
	MemAssocTable *table;
	long code;
{
EXPR_PTR	ep;
int *		ip;
MemId		dup;

	if( !table || !code )
		return -1;

	ep = (EXPR_PTR) code;
	if( !ep )
		return -1;

	if( ep->left )
	{
		ip = (int *) ep->left;
		switch( *ip )
		{
		case VAR_MAGIC:
			dup = MemLookUpAssoc( table, (long) ep->left );
			if( dup )
				ep->left = (char *) dup;			
			break;
		case EXPR_MAGIC:
			xfer_expr( table, (long) ep->left );
			break;
		case FCALL_MAGIC:
			xfer_fcall( table, (long) ep->left );
			break;
		default:
			printf("expr: left: merge: ERROR: unknown thing type\n");
			break;
		}
	}

	if( ep->right )
	{
		ip = (int *) ep->right;
		switch( *ip )
		{
		case VAR_MAGIC:
			dup = MemLookUpAssoc( table, (long) ep->right );
			if( dup )
				ep->right = (char *) dup;
			break;
		case EXPR_MAGIC:
			xfer_expr( table, (long) ep->right );
			break;
		case FCALL_MAGIC:
			xfer_fcall( table, (long) ep->right );
			break;
		default:
			printf("expr: right: merge: ERROR: unknown thing type\n");
			break;
		}
	}

	return 0;
}

/* transfer any refs in the object to global vars, if they need to be changed */

int
xfer_obj( table, op )
	MemAssocTable *table;
	OBJ_PTR	op;
{
int		i;
CODE_PTR	tcp;

	if( !table || !op )
		return -1;

	for( tcp = op->codelist; tcp; tcp = tcp->next )
		xfer_code( table, tcp );

	return 0;
}

int
xfer_code( table, tcp )
	MemAssocTable *table;
	CODE_PTR tcp;
{
int *	ip;
long	newloc;
int	i;

	if( !table || !tcp )
		return -1;

	if( tcp->type != CFUNC_CODESEG )
	{
		for( i=0; i<tcp->ninstr; i++ )
		{
			if( tcp->code[i] > 500 )	/* it's a pointer */
			{
				ip = (int *) tcp->code[i];
				switch( *ip )
				{
				case VAR_MAGIC:
					newloc = MemLookUpAssoc( table, tcp->code[i] );
					if( newloc )
						tcp->code[i] = (unsigned long) newloc;
					break;
				case FCALL_MAGIC:
					xfer_fcall( table, (long) tcp->code[i] );
					break;
				case EXPR_MAGIC:
					xfer_expr( table, (long) tcp->code[i] );
					break;
				default:
					printf("code: merge: ERROR: unknown thing type\n");
					break;
				}
			}
		}
	}

	return 0;
}
