/* ev_Parse.c */

#include <stdio.h>
#include <ctype.h>

#define EV_PARSE_C
#include <X10/Xlib.h>
#include "ev_tokens.h"

ev_SetFile( fp )
	FILE *fp;
{
	theFile = fp;
}

int
ev_Parse()
{
	ev_Script();
}

int
ev_Error( why )
	char *why;
{
char *p;
int i;

	printf("\n");
	printf(">> EventScript Error: %s\n",why);
	printf(">> in line %d:\n",theLineNo);
	for( p=theLine; *p; p++ )
		if( *p == '\t' )
			*p = ' ';
	printf("%s\n",theLine);
	for( i=0; i<(theLoc - theLine)-1; i++ )
		printf(" ");
	printf("^-- ERROR\n");
	printf(">> last token type %d",theToken.type);
	if( strlen(theToken.value) )
		printf("; value <%s>",theToken.value);
	printf("\n\n");
	exit( EV_PARSE_ERR );
}

int
ev_Scan()
{
char c;

	if( eof )
		theToken.type = T_eof;
	else
	{
		theToken.type = T_NULL;
		while( theToken.type == T_NULL )
		{
			if( !strlen(theLoc) )
			{
				ev_NextLine();
				if( eof )
				{
					theToken.type = T_eof;
					strcpy(theToken.value,"*end of file*");
					break;
				}
			}
			c = *theLoc;
			if( !c )		/* blank line */
				continue;
	
			if( isspace(c) )
				while( isspace(c) )
					c = *(++theLoc);
			else if( c == C_comment1 && 
				*(theLoc+1) == C_comment2 )
				ev_Comment();
			else if( isalpha(c) )
				ev_Word();
			else if( isdigit(c) )
				ev_Number();
			else if( strpos(ALL_OPERATORS,c) >= 0 )
				ev_Operator();
			else if( c=='\"' )
				ev_String();
			else
			{
				theToken.type = T_NULL;
				sprintf(theToken.value,"'%c'",c);
				ev_Error( "illegal character");
			}
		}
	}
}

int
ev_Comment()
{
	EV_DEBUG( 1,("got Comment: <%s>\n",theLoc) );
	ev_NextLine();
}

int
ev_Number()
{
int		res;
int		theInt;
float	theFlt;
char *	legalchars = "+-01234567890.";
int		theEnd;
char	theNum[64];


	theEnd = stcis( theLoc, legalchars );
	strncpy(theNum,theLoc,theEnd);
	theNum[theEnd] = '\0';
	theLoc += theEnd;
	if( strpos(theNum,'.') < 0 )
	{
		res = sscanf(theNum, "%d", &theInt );
		if( res==1 )
		{
			theToken.type = T_int;
			strcpy(theToken.value,theNum);
			EV_DEBUG( 1,("got Integer: %d\n",theInt) );
		}
		else
			ev_Error( "invalid integer" );
	}
	else
	{
		res = sscanf(theNum, "%f", &theFlt );
		if( res==1 )
		{
			theToken.type = T_float;
			strcpy(theToken.value,theNum);
			EV_DEBUG( 1,("got Float: %f\n",theFlt) );
		}
		else
			ev_Error( "invalid float number" );
	}
}

int
ev_Word()
{
char	theWord[MAXSTR];
char *	stpsym();

	theLoc = stpsym( theLoc, theWord, MAXSTR );
	strcpy( theToken.value, theWord );
	theToken.type = ev_WordType( theWord );
	if( isdigit(*theLoc) || isalpha(*theLoc) )
		ev_Error( "string too large" );
	if( theToken.type == T_word )
	{
		EV_DEBUG(1,("got Word <%s>, type %d\n",theToken.value,theToken.type));
	}
	else if( IsOperator(theToken.type) )
	{
		EV_DEBUG(1,("got Operator Word <%s>, type %d\n",theToken.value,theToken.type));
	}
	else if( IsControl(theToken.type) )
	{
		EV_DEBUG(1,("got Control Word <%s>, type %d\n",theToken.value,theToken.type));
	}
	else if( IsConnector(theToken.type) )
	{
		EV_DEBUG(1,("got Connector Word <%s>, type %d\n",theToken.value,theToken.type));
	}	
	else if( IsCommand(theToken.type) )
	{
		EV_DEBUG(1,("got Command Word <%s>, type %d\n",theToken.value,theToken.type));
	}
	else
		ev_Error( "unknown Word type" );
}

int
ev_WordType( word )
	char *word;
{
int	i;

	for( i=0; i<NumOperators; i++ )			/* check for Operator Words */
		if( !strcmp(word,Operators[i].string) )
			return Operators[i].code;
	for( i=0; i<NumControls; i++ )
		if( !strcmp(word,Controls[i].string) )
			return Controls[i].code;
	for( i=0; i<NumCommands; i++ )
		if( !strcmp(word,Commands[i].string) )
			return Commands[i].code;
	for( i=0; i<NumConnectors; i++ )
		if( !strcmp(word,Connectors[i].string) )
			return Connectors[i].code;
	return T_word;
}

char *
OpStr( t )
	int t;
{
int		i;

	for( i=0; i<NumOperators; i++ )
		if( t==Operators[i].code )
			return Operators[i].string;
	return NULL;
}

int
PrintInstr( ins )
	unsigned long ins;
{
int i;
VAR_PTR	vp;
EXPR_PTR ep;
FCALL_PTR fcp;
int *	ip;

	for( i=0; i<NumControls; i++ )
		if( ins == (long) Controls[i].code )
		{
			printf("%s",Controls[i].string);
			return 0;
		}
	for( i=0; i<NumCommands; i++ )
		if( ins == (long) Commands[i].code )
		{
			printf("%s",Commands[i].string);
			return 0;
		}
	for( i=0; i<NumConnectors; i++ )
		if( ins == (long) Connectors[i].code )
		{
			printf("%s",Connectors[i].string);
			return 0;
		}
	for( i=0; i<NumOperators; i++ )
		if( ins == (long) Operators[i].code )
		{
			printf("%s",Operators[i].string);
			return 0;
		}
	ip = (int *) ins;
	if( ip && *ip == VAR_MAGIC )
	{
		vp = (VAR_PTR) ins;
		show_var(vp);
		return 0;
	}
	else if( ip && *ip == EXPR_MAGIC )
	{
		ep = (EXPR_PTR) ins;
		print_expr(ep);
		return 0;
	}
	else if( ip && *ip == FCALL_MAGIC )
	{
		fcp = (FCALL_PTR) ins;
		print_fcall(fcp);
		return 0;
	}

	printf("[unknown instruction %d]", ins );
	return -1;
}

int
print_fcall( fcp )
	FCALL_PTR	fcp;
{
int 	i;
int	*ip;

	printf("%s( ",fcp->func->name);
	for( i=0; i<fcp->nparms; i++ )
	{
		ip = (int *) fcp->parms[i];
		if( ip && *ip == VAR_MAGIC )
			show_var( (VAR_PTR) ip );
		else if( ip && *ip == EXPR_MAGIC )
			print_expr( (EXPR_PTR) ip );
		else if( ip && *ip == FCALL_MAGIC )
			print_fcall( (FCALL_PTR) ip );
		if( (i+1) < fcp->nparms )
			printf(", ");
	}
	printf(" ) ");
	return 0;
}

int
ev_Operator()
{
int	loc;

	*theToken.value = 0;
	
	/* first see if it's a single operator */
	loc = strpos( SINGLE_OPERATORS, *theLoc );
	if( loc >= 0 )
		theToken.type = OPERATOR + loc;
	else if( (loc = strpos(DOUBLE_OPERATORS, *theLoc)) >= 0 )
	{
		if( *theLoc == '>' )
		{
			if( *(theLoc+1) == '=' )
			{
				theToken.type = T_GTE;
				strcpy(theToken.value,">=");
			}
			else if( strpos(SINGLE_OPERATORS, *(theLoc+1)) >= 0 ||
				strpos(DOUBLE_OPERATORS, *(theLoc+1)) >= 0 )
				ev_Error( "illegal double operator" );
			else
				theToken.type = T_GT;
		}
		else if( *theLoc == '<' )
		{
			if( *(theLoc+1) == '=' )
			{
				theToken.type = T_LTE;
				strcpy(theToken.value,"<=");
			}
			else if( *(theLoc+1) == '>' )
			{
				theToken.type = T_notequal;
				strcpy(theToken.value,"<>");
			}
			else if( strpos(SINGLE_OPERATORS, *(theLoc+1)) >= 0 ||
				strpos(DOUBLE_OPERATORS, *(theLoc+1)) >= 0 )
				ev_Error( "illegal double operator" );
			else
				theToken.type = T_LT;
		}
		else if( *theLoc == '&' )
		{
			if( *(theLoc+1) == '&' )
			{
				theToken.type = T_catspace;
				strcpy(theToken.value,"&&");
			}
			else if( strpos(SINGLE_OPERATORS, *(theLoc+1)) >= 0 ||
				strpos(DOUBLE_OPERATORS, *(theLoc+1)) >= 0 )
				ev_Error( "illegal double operator" );
			else
				theToken.type = T_cat;
		}
	}
	else if( (loc = strpos(SEP_OPERATORS, *theLoc)) >= 0 )
	{
		theToken.type = T_comma + loc;
	}
	
	if( *theToken.value )	/* got a double operator */
	{
		EV_DEBUG( 1,("got Double Operator '%s'\n",theToken.value) );
		theLoc += 2;
	}
	else
	{
		EV_DEBUG( 1,("got Operator '%c'\n",*theLoc) );
		++theLoc;
	}
}

int
ev_String()
{
char *theEnd;
char *stpchr();

	++theLoc;
	if( (theEnd = stpchr(theLoc, '\"')) )
	{
		sscanf(theLoc,"%[^\"]\"",theToken.value);
		theLoc = theEnd+1;
		theToken.type = T_string;
		EV_DEBUG( 1,("got String \"%s\"\n",theToken.value) );
	}
	else
	{
		theToken.type = T_string;
		strcpy(theToken.value,theLoc);
		ev_Error( "bad string" );
	}
}

int
ev_NextLine()
{
int	len;

	if( eof )
		ev_Error( "reading past end of file" );
	if( fgets(theLine, 255, theFile) )
	{
		++theLineNo;
		len = strlen(theLine);
		if( theLine[len-1] == '\n' )
			theLine[len-1] = '\0';
		theLoc = theLine;
	}
	else
		eof = 1;
}
