void
signal_unexpected(what,funcname,linecount)
 char *what, *funcname;
 int linecount;
{
printf("%s: Unexpected %s at line %d.\n",funcname,what,linecount);
exit(1);
}

void
signal_missing_data(what,funcname,linecount)
     char *what, *funcname;
     int linecount;
{
  printf("%s: Missing %s at line %d\n",funcname,what,linecount);
}



#define NKEYS 19
#define DISPLAY 1
#define DSP_ELEMENT 2
#define SCR_ELEMENT 3
#define MAP 4
#define DIMENSION 5
#define INCLUDE 6
#define NAME 7
#define NEXT 8
#define TYPE 9
#define ACTIVE 10
#define LABEL 11
#define IN_POINT 12
#define OUT_POINT 13
#define ICON 14
#define FILENAME 15
#define MAX 16
#define MIN 17
#define RANGE 18
#define BOUNDARY 19

int 
lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "display", 1,
    "element", 2,
    "screen", 3,
    "map", 4,
    "dimension", 5,
    "include", 6,
    "name", 7,
    "next", 8,
    "type", 9,
    "active", 10,
    "label", 11,
    "in", 12,
    "out", 13,
    "icon", 14,
    "filename", 15,
    "max", 16,
    "min", 17,
    "range", 18,
    "boundary", 19
    };

  for(i=0;i<NKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}



#define VKEYS 8
#define VIDEO 1
#define TEXT 2

int 
lookupval(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "yes", 1,
    "no", 0,
    "video", 1,
    "text", 2,
    "wrap", 1,
    "freeze", 2,
    "bounce", 3,
    "limit", 4
    };

  for(i=0;i<VKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}


#define TKkeys 26
#define TK_WINDOW 1
#define TK_LABEL 2
#define TK_FONT 3
#define TK_BORDERWIDTH 4
#define TK_FOREGROUND 5
#define TK_BACKGROUND 6
#define TK_BORDER 7
#define TK_WIDTH 8
#define TK_HEIGHT 9
#define TK_JUSTIFY 10
#define TK_FUNCTION 11
#define TK_PARAMETER 12
#define TK_HIGHLIGHT 13 
#define TK_UNHIGHLIGHT 14
#define TK_NOTIFY 15
#define TK_ORIENTATION 16
#define TK_THUMB 17
#define TK_SCROLLUPDOWNPROC 18
#define TK_THUMBPROC 19
#define TK_TOPPERCENT 20
#define TK_SHOWNPERCENT 21
#define TK_HSPACE 22
#define TK_VSPACE 23
#define TK_DIALOGVALUE 24
#define TK_DIALOGBUTTONS 25
#define TK_NAME 26

int 
TK_lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[TKkeys] = {
    "window", 1, 
    "label", 2,
    "font", 3,
    "borderwidth", 4,
    "foreground", 5,
    "background", 6,
    "border", 7,
    "width", 15,
    "height", 16,
    "justify", 8,
    "function", 9,
    "parameter", 10,
    "highlight", 11,
    "unhighlight", 12,
    "notify", 13,
    "orientation", 14,
    "thumb", 17,
    "scrollupdownproc", 18,
    "thumbproc", 19,
    "toppercent", 20,
    "shownpercent", 21,
    "hspace", 22,
    "vspace", 23,
    "dialogvalue", 24,
    "dialogbuttons", 25,
    "name", 26
    };

  for(i=0;i<TKkeys;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}

