% setup parameters and variables
n0 = 1.55;
nsub = 1.55;
np = 100;
ny = 1024;
y1 = 0.6; y2 = 1.2;
y0 = 0.6;
ys = linspace(y1, y2, ny).';
ks = 2*pi./ys;

% load material indices
load materials
[nlo, nlody, nloddy] = dnsell(ys, s.sio2);  % first layer
[nhi, nhidy, nhiddy] = dnsell(ys, s.tio2);  % second layer
[nsub, nsubdy, nsubddy] = dnsell(ys, s.fs);  % substrate
nsubdy = nsubdy*0; nsubddy = nsubddy*0;

% compute k derivatives from lambda derivatives
nlod = -2*pi*nlody./ks.^2;
nlodd = 4*pi*nlody./ks.^3 + 4*pi^2*nloddy./ks.^4;
nhid = -2*pi*nhidy./ks.^2;
nhidd = 4*pi*nhidy./ks.^3 + 4*pi^2*nhiddy./ks.^4;
nsubd = -2*pi*nsubdy./ks.^2;
nsubdd = 4*pi*nsubdy./ks.^3 + 4*pi^2*nsubddy./ks.^4;

% compute repeating matrix of indices for use in full GDD function
if mod(np,2)  % odd
  ns = [repmat([nlo, nhi], 1, np), nlo, nsub];
  dns = [repmat([nlod, nhid], 1, np), nlod, nsubd];
  ddns = [repmat([nlodd, nhidd], 1, np), nlodd, nsubdd];
else
  ns = [repmat([nlo, nhi], 1, np), nsub];
  dns = [repmat([nlod, nhid], 1, np), nsubd];
  ddns = [repmat([nlodd, nhidd], 1, np), nsubdd];
end

% compute simple two material matrix for use in fast GDD function
ns2 = [ns(:,1), ns(:,2), ns(:,end)];
dns2 = [dns(:,1), dns(:,2), dns(:,end)];

% generate contrived stack example
dhigh = y0/nhi(end)/4;
dlow = y0/nlo(end)/4;
ds0 = repmat([dlow, dhigh], 1, np);
nl = length(ds0);
ds = ds0.*linspace(1,2,nl);
theta = 5/180*pi;
pol = 'TE';

% run computations
tic
[r, gd, gdd] = stackgdd(ks, ds, n0, ns, dns, ddns, theta, pol);
toc
tic
[rfast, gdfast, gddfast] = stackgddfast(ks, ds, n0, ns2, dns2, theta, pol);
toc
tic
[rfastmex, gdfastmex, gddfastmex] = stackgddfastmexwrap(ks, ds, n0, ns2, dns2, theta, pol);
toc

% plot results
figure(1)
plot(ys, [gd, gdfast, gdfastmex.'])
legend('stackgdd', 'stackgddfast', 'gddfastmex')
title('GD Test')
axis tight

figure(2)
plot(ys, [gdd, gddfast, gddfastmex.'])
legend('stackgdd', 'stackgddfast', 'gddfastmex')
title('GDD Test')
axis tight

