function n = nsell(y, S)
%NSELL  Calculate index from Sellmier coefficients
% n = nsell(y, S) is the index at wavelength y, given
% the Sellmier coefficients given in matrix S, where the first column is
% the B coefficients and the second are the C coefficients.

[ns, n] = size(S);
y2 = y.^2;

% Calculate terms over all wavelengths in parallel.
terms = 0;
for k = 1:ns,
  terms = terms + S(k,1)*y2./(y2 - S(k,2));
end

n = sqrt(1 + terms);
