/* errno.h standard header 
 * $Version: 1.9 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _ERRNO
#define _ERRNO

#include <yvals.h>

/*
 * [1]-STANDARD C DEFINITIONS
 */
#if (_model_rmx) || (_model_blue) || (_model_posix) || (_model_green)

/*
 * macro definitons
 */

#define EPERM        1        /* Not super-user */
#define ENOENT       2        /* No such file or directory */
#define ESRCH        3        /* No such process */
#define EINTR        4        /* interrupted system call */
#ifndef EIO
#define EIO          5        /* I/O error */
#endif
#define ENXIO        6        /* No such device or address */
#define E2BIG        7        /* Arg list too long */
#define ENOEXEC      8        /* Exec format error */
#define EBADF        9        /* Bad file number */
#define ECHILD      10        /* No children */
#define EAGAIN      11        /* No more processes */
#define ENOMEM      12        /* Not enough core */
#define EACCES      13        /* Permission denied */
#define EFAULT      14        /* Bad address */
#define ENOTBLK     15        /* Block device required */
#ifndef EBUSY
#define EBUSY       16        /* Mount device busy */
#endif
#ifndef EEXIST
#define EEXIST      17        /* File exists */
#endif
#define EXDEV       18        /* Cross-device link */
#define ENODEV      19        /* No such device */
#define ENOTDIR     20        /* Not a directory */
#define EISDIR      21        /* Is a directory */
#define EINVAL      22        /* Invalid argument */
#define ENFILE      23        /* File table overflow */
#define EMFILE      24        /* Too many open files */
#define ENOTTY      25        /* Not a typewriter */
#define ETXTBSY     26        /* Text file busy */
#define EFBIG       27        /* File too large */
#define ENOSPC      28        /* No space left on device */
#define ESPIPE      29        /* Illegal seek */
#define EROFS       30        /* Read only file system */
#define EMLINK      31        /* Too many links */
#define EPIPE       32        /* Broken pipe */
#define EDOM        _EDOM     /* Math arg out of domain of func */
#define ERANGE      _ERANGE   /* Math result not representable */
#define ENOMSG      35        /* No message of desired type */
#define EIDRM       36        /* Identifier removed */
#define ECHRNG      37        /* Channel number out of range */
#define ELNRNG      38        /* Link number out of range */
#define EUNATCH     39        /* Protocol driver not attached */
#define EDEADLK     42        /* Deadlock condition. */
#define ENOLCK      43        /* No record locks available. */
#define EFREE       44        /* bad free pointer. */
#define ESIGNAL     45        /* bad signal vector. */
#define ENOIMPL     46        /* function not implemented. */

/*
 * Convergent Technologies errors
 */

#ifndef CTIERR
#define CTIERR          _CTIERR        
#define EBADE           (CTIERR+0)      /* invalid exchange */
#define EBADR           (CTIERR+1)      /* invalid request descriptor */
#define EXFULL          (CTIERR+2)      /* exchange full */
#define ENOANO          (CTIERR+3)      /* no anode */
#define EBADRQC         (CTIERR+4)      /* invalid request code */
#define EDEADLOCK       (CTIERR+6)      /* file locking deadlock error */
#define EBADSLT         (CTIERR+5)      /* invalid slot */
#define EBFONT          (CTIERR+7)      /* bad font file fmt */
#endif

/*
 * Stream errors
 */

#ifndef STRERR
#define STRERR          _STRERR 
#define ENOSTR          (STRERR+0)      /* Device not a stream */
#define ENODATA         (STRERR+1)      /* no data (for no delay io) */
#ifndef ETIME
#define ETIME           (STRERR+2)      /* timer expired */
#endif
#define ENOSR           (STRERR+3)      /* out of streams resources */
#define ENONET          (STRERR+4)      /* Machine is not on the network */
#define ENOPKG          (STRERR+5)      /* Package not installed */
#define EREMOTE         (STRERR+6)      /* The object is remote */
#define ENOLINK         (STRERR+7)      /* the link has been severed */
#define EADV            (STRERR+8)      /* advertise error */
#define ESRMNT          (STRERR+9)      /* srmount error */
#define ECOMM           (STRERR+10)     /* Communication error on send */
#define EPROTO          (STRERR+11)     /* Protocol error */
#define EMULTIHOP       (STRERR+14)     /* multihop attempted */
#define EDOTDOT         (STRERR+16)     /* Cross mount point (not really error)*/
#define EBADMSG         (STRERR+17)     /* trying to read unreadable message */
#define ENAMETOOLONG    (STRERR+18)     /* path name is too long */
#ifndef EOVERFLOW
#define EOVERFLOW       (STRERR+19)     /* value toobig to store in datatype */
#endif
#define ENOTUNIQ        (STRERR+20)     /* given log. name not unique */
#define EBADFD          (STRERR+21)     /* f.d. invalid for this operation */
#define EREMCHG         (STRERR+22)     /* Remote address changed */
#endif

/*
 * Shared Library errors
 */

#ifndef SHLIBERR
#define SHLIBERR        _SHLIBERR
#define ELIBACC         (SHLIBERR+0)    /* Can't access a needed shared lib. */
#define ELIBBAD         (SHLIBERR+1)    /* Accessing a corrupted shared lib. */
#define ELIBSCN         (SHLIBERR+2)    /* .lib section in a.out corrupted. */
#define ELIBMAX         (SHLIBERR+3)    /* Attempting to link in too many libs. */
#define ELIBEXEC        (SHLIBERR+4)    /* Attempting to exec a shared library. */
#define EILSEQ          (SHLIBERR+5)    /* Illegal byte sequence. */
#define ENOSYS          (SHLIBERR+6)    /* Unsupported filesys op */
#define ELOOP           (SHLIBERR+7)    /* Symbolic link loop */
#define ERESTART        (SHLIBERR+8)    /* Restartable system call */
#define ESTRPIPE        (SHLIBERR+9)    /* if pipe/fifo no sleep in strhd */
#define ENOTEMPTY       (SHLIBERR+10)   /* directory not empty */
#define EUSERS          (SHLIBERR+11)   /* Too many users for UFS */
#endif

/*
 * TCP/IP Networking errors
 */

#ifndef TCPERR
#define TCPERR          _TCPERR   
#define EWOULDBLOCK     (TCPERR+0)      /* Operation would block */
#define EINPROGRESS     (TCPERR+1)      /* Operation now in progress */
#define EALREADY        (TCPERR+2)      /* Operation already in progress */
#define ENOTSOCK        (TCPERR+3)      /* Socket operation on non-socket */
#define EDESTADDRREQ    (TCPERR+4)      /* Destination address required */
#define EMSGSIZE        (TCPERR+5)      /* Message too long */
#define EPROTOTYPE      (TCPERR+6)      /* Protocol wrong type for socket */
#define EPROTONOSUPPORT (TCPERR+7)      /* Protocol not supported */
#define ESOCKTNOSUPPORT (TCPERR+8)      /* Socket type not supported */
#define EOPNOTSUPP      (TCPERR+9)      /* Operation not supported on socket */
#define EPFNOSUPPORT    (TCPERR+10)     /* Protocol family not supported */
#define EAFNOSUPPORT    (TCPERR+11)     /* Address family not supported by
										   protocol family */
#define EADDRINUSE      (TCPERR+12)     /* Address already in use */
#define EADDRNOTAVAIL   (TCPERR+13)     /* Can't assign requested address */
#define ENETDOWN        (TCPERR+14)     /* Network is down */
#define ENETUNREACH     (TCPERR+15)     /* Network is unreachable */
#define ENETRESET       (TCPERR+16)     /* Network dropped connection on reset */
#define ECONNABORTED    (TCPERR+17)     /* Software caused connection abort */
#define ECONNRESET      (TCPERR+18)     /* Connection reset by peer */
#define ENOBUFS         (TCPERR+19)     /* No buffer space available */
#define EISCONN         (TCPERR+20)     /* Socket is already connected */
#define ENOTCONN        (TCPERR+21)     /* Socket is not connected */
#define ESHUTDOWN       (TCPERR+22)     /* Can't send after socket shutdown */
#define ETOOMANYREFS    (TCPERR+23)     /* Too many references: can't splice */
#define ETIMEDOUT       (TCPERR+24)     /* Connection timed out */
#define ECONNREFUSED    (TCPERR+25)     /* Connection refused */
#define EHOSTDOWN       (TCPERR+26)     /* Host is down */
#define EHOSTUNREACH    (TCPERR+27)     /* No route to host */
#define ENOPROTOOPT     (TCPERR+28)     /* Protocol not available */
#endif

/*
 * XENIX errors
 */

#ifndef XNXERR
#define XNXERR          _XNXERR
#define EUCLEAN         (XNXERR+0)      /* Structure needs cleaning */
#define ENOTNAM         (XNXERR+2)      /* Not a name file */
#define ENAVAIL         (XNXERR+3)      /* Not available */
#define EISNAM          (XNXERR+4)      /* Is a name file */
#define EREMOTEIO       (XNXERR+5)      /* Remote I/O error */
#define EINIT           (XNXERR+6)      /* Reserved for future */
#define EREMDEV         (XNXERR+7)      /* Error 142 */
#endif

/*
 * SUN NFS errors
 */

#ifndef SUNERR
#define SUNERR          _SUNERR
#define ESTALE          (SUNERR+0)      /* Stale NFS file handle */
#endif

/*
 * Pyramid AIO (raw disk I/O) errors
 */

#ifndef PYRERR
#define PYRERR          _PYRERR
#define EIORESID        (PYRERR+0)      /* block not fully transferred */
#endif

#define ETABOO          _ETABOO         /* Don't use, confuse with (char) -1 */
#define _NUM_ERR_NUMS   _ERRMAX         /* for strerror() */
#define _NERR           _ERRMAX         /* for strerror() */

#endif /* rmx, blue, posix and green */

/*
 * [2]-COMMON DEFINITIONS THAT ARE NOT STANDARD C DEFINITIONS
 */
#if (_model_blue) || (_model_posix) || (_model_green)
#endif /* blue, posix and green */

/*
 * [3]-COMMON NETWORK DEFINITIONS (same as _UNIX_SOURCE)
 */
#if (_model_blue) || (_model_green)
#endif /* blue and green */

/*
 * [4]-COMMON NON-POSIX DEFINITIONS
 */
#if (_model_rmx) || (_model_blue)

#include <reent.h>

/*
 * errno definiton
 */

#define errno (_thread_ptr()->_errno)

#endif /* rmx and blue */

/*
 * [5]-POSIX SPECIFIC DEFINITIONS (same as _POSIX_SOURCE)
 */
#if (_model_posix) || (_model_green)

/*
 * errno definiton
 */

extern int errno;

#endif /* posix and green */

/*
 * [6]-RMX SPECIFIC DEFINITIONS
 */
#if (_model_rmx)
#endif /* rmx */

/*
 * [7]-NON-POSIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_blue)
#endif /* blue */

/*
 * [8]-UNIX/UNIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_green)
#endif /* green */

#endif /* _ERRNO */
