/********************************************************************
*                                                                   *
*       Copyright 1988 Intel Corporation, all rights reserved.      *
*                                                                   *
*           INTEL CORPORATION PROPRIETARY INFORMATION               *
*                                                                   *
*      This software is supplied under the terms of a license       *
*      agreement or nondisclosure agreement with Intel Corpo-       *
*      ration and may not be copied or disclosed except in          *
*      accordance with the terms of that agreement.                 *
*                                                                   *
********************************************************************/

#ifndef __RMK_BASEH__
#define __RMK_BASEH__

#include <yvals.h>
#include <rmk_base.l>

		/*  Kernel Exported Procedures (PL/M) */

extern UINT_8 *                KN_current_task;

KN_TOKEN _Pascal	KN_create_semaphore
(
	UINT_32		far *area_ptr,
	KN_FLAGS	flags
);

void _Pascal		KN_delete_semaphore
(
	KN_TOKEN	semaphore
);

void _Pascal		KN_send_unit
(
	KN_TOKEN	semaphore
);

KN_STATUS _Pascal	KN_receive_unit
(
	KN_TOKEN	semaphore,
	UINT_32		time_limit
);

KN_TOKEN _Pascal	KN_create_mailbox
(
	UINT_32		far *area_ptr,
	UINT_32		message_size,
	UINT_32		queue_size,
	KN_FLAGS	flags
);

void _Pascal		KN_delete_mailbox
(
	KN_TOKEN	mailbox
);

KN_STATUS _Pascal	KN_send_data
(
	KN_TOKEN	mailbox,
	void 		far *data_ptr,
	UINT_32		length
);

KN_STATUS _Pascal	KN_send_priority_data
(
	KN_TOKEN	mailbox,
	void		far *data_ptr,
	UINT_32		length
);

KN_STATUS _Pascal	KN_receive_data
(
	KN_TOKEN	mailbox,
	void		far *data_ptr,
	UINT_32		far *length_ptr,
	UINT_32		time_limit
);

void _Pascal		KN_stop_scheduling
(void);

void _Pascal		KN_start_scheduling
(void);

void _Pascal		KN_sleep
(
	UINT_32		time_limit
);

KN_TOKEN _Pascal	KN_create_alarm
(
	UINT_32		far *area_ptr,
	void		far *handler_ptr,
	UINT_32		time_limit,
	KN_FLAGS	flags
);

void _Pascal		KN_delete_alarm
(
	KN_TOKEN	alarm
);

void _Pascal		KN_reset_alarm
(
	KN_TOKEN	alarm
);


#if _LONG64_

UINT_64 _Pascal		KN_get_time
(void);

void _Pascal		KN_set_time
(
	UINT_64		time
);

#endif


void _Pascal		KN_tick
(void);

KN_TOKEN _Pascal	KN_create_pool
(
	void		far *pool_ptr,
	UINT_32		size
);

void _Pascal		KN_delete_pool
(
	KN_TOKEN	pool
);

void _Pascal		KN_get_pool_attributes
(
	KN_TOKEN					pool,
	KN_POOL_ATTRIBUTES_STRUC    far *attributes_ptr
);

void * _Pascal		KN_create_area
(
	KN_TOKEN	pool,
	UINT_32		size
);

void _Pascal		KN_delete_area
(
	void		far *area,
	KN_TOKEN	pool
);

void _Pascal		KN_set_handler
(
	KN_HDLR_STRUC	far *hdlr_area
);

void _Pascal		KN_reset_handler
(
	KN_HDLR_STRUC	far *hdlr_area
);

void _Pascal		KNE_get_time
(
	KN_TIME_STRUCT	far *time_struct
);

void _Pascal		KNE_set_time
(
	KN_TIME_STRUCT	far *time_struct
);

#endif	/* __RMK_BASEH__ */

